/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsCollectionContaining;
import org.hamcrest.core.IsNot;
import org.junit.Assert;

public class ViewPrincipalTest
extends CrowdAcceptanceTestCase {
    private static final String ATLASSIAN_DIRECTORY_NAME = "Atlassian";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("viewprincipaltest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testPrincipalDetailsShowDirectoryDescription() {
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.assertTextPresent("Atlassian \u2014 Crowd Internal Directory");
    }

    public void testUpdateMainAttributes() {
        this.intendToModifyData();
        this.log("Running: testUpdateMainAttributes");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("firstname", "Billy");
        this.setTextField("lastname", "Bob");
        this.setTextField("email", "billy@atlassian.com");
        this.uncheckCheckbox("active");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("firstname", "Billy");
        this.assertTextFieldEquals("lastname", "Bob");
        this.assertTextFieldEquals("email", "billy@atlassian.com");
        this.assertCheckboxNotSelected("active");
    }

    public void testRenameUser() {
        this.intendToModifyData();
        this.log("Running: testRenameUser");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("newName", "jkoke");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("newName", "jkoke");
    }

    public void testRenameUserCausesNameClash() {
        this.intendToModifyData();
        this.log("Running: testRenameUser");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("newName", "admin");
        this.submit();
        this.assertKeyPresent("invalid.namealreadyexist");
    }

    public void testRenameUserIsNotSupportedForLDAPDirectories() {
        this.intendToModifyData();
        this.log("Running: testRenameUser");
        this.gotoViewPrincipal("jdoe", "Apache DS");
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("newName", "new-name");
        this.submit();
        this.assertWarningPresent();
        this.assertTextPresent("User renaming is not supported for LDAP directories");
    }

    public void testChangePasswordDoesNotMatchComplexityRequirements() {
        this.intendToModifyData();
        this.log("Running: testChangePasswordDoesNotMatchComplexityRequirements");
        this.updateDirectoryWithPasswordRegex(ATLASSIAN_DIRECTORY_NAME, "[a-z]", "Passwords <b>must</b> contain at least one lowercase character");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("password", "ALL-UPPERCASE-PASSWORD");
        this.setTextField("passwordConfirm", "ALL-UPPERCASE-PASSWORD");
        this.submit();
        this.assertKeyNotPresent("updatesuccessful.label");
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
    }

    public void testAddNewPrincipalAttribute() {
        this.intendToModifyData();
        this.log("Running: testAddNewPrincipalAttribute");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("user-attributes-tab");
        this.setWorkingForm("attributesForm");
        this.setTextField("attribute", "company");
        this.setTextField("value", ATLASSIAN_DIRECTORY_NAME);
        this.clickButton("add-attribute");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextInTable("attributesTable", new String[]{"company", ATLASSIAN_DIRECTORY_NAME});
    }

    public void testShouldNotAllowToAddNewPrincipalEmptyAttribute() {
        this.log("Running: testShouldNotAllowToAddNewPrincipalEmptyAttribute");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("user-attributes-tab");
        this.setWorkingForm("attributesForm");
        this.setTextField("attribute", "");
        this.setTextField("value", ATLASSIAN_DIRECTORY_NAME);
        this.clickButton("add-attribute");
        this.assertKeyNotPresent("updatesuccessful.label");
        this.assertErrorPresentWithKey("principal.attributename.invalid");
        Function<List<String>, String> getAttributeNames = new Function<List<String>, String>(){

            public String apply(@Nullable List<String> row) {
                return row.get(0);
            }
        };
        List<String> attributes = this.scrapeTable("attributesTable", (List<String>)ImmutableList.of((Object)"Attribute", (Object)"Values", (Object)"Action"), getAttributeNames);
        Assert.assertThat(attributes, (Matcher)IsNot.not((Matcher)IsCollectionContaining.hasItem((Object)"")));
    }

    public void testUpdatePrincipalAttributes() {
        this.intendToModifyData();
        this.log("Running: testUpdatePrincipalAttributes");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("user-attributes-tab");
        this.setWorkingForm("attributesForm");
        this.setTextField("phone1", "9999-5555");
        this.setTextField("country1", "Tibet");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextInTable("attributesTable", new String[]{"9999-5555", "Tibet"});
    }

    public void testUpdatePrincipalWithTrailingWhitespaceFailsWithSpecificError() {
        this.log("Running: testUpdatePrincipalWithTrailingWhitespace");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("email", " foo@example.test ");
        this.submit();
        this.assertKeyPresent("principal.email.whitespace");
    }

    public void testRemovePrincipalAttribute() {
        this.intendToModifyData();
        this.log("Running: testRemovePrincipalAttribute");
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.setWorkingForm("attributesForm");
        this.clickLink("remove-country");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("attributesTable", new String[]{"country", "Australia"});
    }

    public void testEditApacheDSPrincipal() {
        this.intendToModifyData();
        this.intendToModifyLdapData();
        this.gotoViewPrincipal("jdoe", "Apache DS");
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("firstname", "John");
        this.setTextField("lastname", "Small");
        this.setTextField("email", "john@test.org");
        this.submit();
        this.assertTextFieldEquals("firstname", "John");
        this.assertTextFieldEquals("lastname", "Small");
        this.assertTextFieldEquals("email", "john@test.org");
    }

    public void testRemoveUserNotPossibleEvenViaUrlHack() {
        this._loginAdminUser();
        this.gotoRemovePrincipal("admin", ATLASSIAN_DIRECTORY_NAME);
        this.assertFormNotPresent("remove-user-form");
        this.assertKeyPresent("principal.remove.curent.user");
    }

    public void testRemoveUserLinkNotPresentForLoggedInUser() {
        this._loginAdminUser();
        this.gotoViewPrincipal("admin", ATLASSIAN_DIRECTORY_NAME);
        this.assertLinkNotPresent("remove-principal");
    }

    public void testRemoveUser() {
        this.intendToModifyData();
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("remove-principal");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotPresent("justin@atlassian.com");
    }

    public void testViewUserGroupsTabWithNoModifyGroupPermissions() {
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("internal-permissions");
        this.setWorkingForm("permissionForm");
        this.uncheckCheckbox("permissionGroupModify");
        this.submit();
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        this.assertKeyPresent("group.modify.disabled");
        this.assertButtonNotPresent("addGroups");
        this.assertButtonNotPresent("removeGroups");
        this.assertTextInTable("groupsTable", new String[]{"crowd-administrators", "", "true"});
    }

    public void testViewUserGroupsTabWithModifyGroupPermissions() {
        this.gotoViewPrincipal("justin", ATLASSIAN_DIRECTORY_NAME);
        this.clickLink("user-groups-tab");
        this.assertKeyNotPresent("group.modify.disabled");
        this.assertButtonPresent("addGroups");
        this.assertButtonPresent("removeGroups");
        this.assertTextInTable("groupsTable", new String[]{"crowd-administrators", "", "true"});
    }

    public void testViewUserWithUserNameWhichContainsNonAsciiCharacters() {
        this.intendToModifyData();
        this.gotoAddPrincipal();
        this.setTextField("email", "testuser@atlassian.com");
        this.setTextField("name", "john.t\u00f8stin\u00f3g\u00e9");
        this.setTextField("password", "password");
        this.setTextField("passwordConfirm", "password");
        this.setTextField("firstname", "Test");
        this.setTextField("lastname", "User");
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.assertTextPresent("john.t\u00f8stin\u00f3g\u00e9");
    }

    private void updateDirectoryWithPasswordRegex(String directoryName, String passwordRegex, String passwordComplexityMessage) {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText(directoryName);
        this.clickLink("internal-configuration");
        this.setTextField("passwordRegex", passwordRegex);
        this.setTextField("passwordComplexityMessage", passwordComplexityMessage);
        this.submit();
        this.assertTextFieldEquals("passwordComplexityMessage", passwordComplexityMessage);
    }
}

