/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import com.atlassian.crowd.model.event.UserMembershipEvent;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

class UserMembershipEventMatcher
extends TypeSafeMatcher<OperationEvent> {
    private Operation operation;
    private Matcher<Directory> directory;
    private Matcher<String> childUsername;
    private Matcher<Set<String>> parentGroupNames;

    public UserMembershipEventMatcher(Operation operation, Matcher<Directory> directory, Matcher<String> childUsername, Matcher<Set<String>> parentGroupNames) {
        this.operation = operation;
        this.directory = directory;
        this.childUsername = childUsername;
        this.parentGroupNames = parentGroupNames;
    }

    public boolean matchesSafely(OperationEvent item) {
        try {
            UserMembershipEvent userMembershipEvent = (UserMembershipEvent)item;
            return this.operation.equals((Object)userMembershipEvent.getOperation()) && this.directory.matches((Object)userMembershipEvent.getDirectory()) && this.childUsername.matches((Object)userMembershipEvent.getChildUsername()) && this.parentGroupNames.matches((Object)userMembershipEvent.getParentGroupNames());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("a user membership " + this.operation + " event for user " + this.childUsername + " and groups " + this.parentGroupNames + " in directory " + this.directory);
    }

    @Factory
    public static UserMembershipEventMatcher userMembershipCreated(String username, Set<String> groupNames) {
        return new UserMembershipEventMatcher(Operation.CREATED, (Matcher<Directory>)CoreMatchers.nullValue(Directory.class), (Matcher<String>)CoreMatchers.is((Object)username), (Matcher<Set<String>>)CoreMatchers.is(groupNames));
    }

    @Factory
    public static UserMembershipEventMatcher userMembershipCreated(String username, String groupName) {
        return UserMembershipEventMatcher.userMembershipCreated(username, (Set<String>)ImmutableSet.of((Object)groupName));
    }
}

