/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.math.NumberUtils;

public class UpdateConnectionPoolTest
extends CrowdAcceptanceTestCase {
    private static final String TIMEOUT_IN_SECONDS = String.valueOf(TimeUnit.SECONDS.convert(NumberUtils.toLong((String)"30000"), TimeUnit.MILLISECONDS));

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
    }

    public void testNoChange() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.submit();
        this.checkDefaultValues();
        this.assertTextNotPresent("new value");
    }

    public void testInvalidChange() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("initialSize", "blahblah");
        this.setTextField("maximumSize", "20");
        this.setTextField("timeoutInSec", "420");
        this.setTextField("supportedProtocol", "ssl");
        this.submit();
        this.assertErrorPresentWithKey("connectionpool.integer.invalid");
        this.assertErrorPresentWithKey("connectionpool.update.error");
        this.assertTextNotPresent("(new value: blahblah)");
        this.assertTextPresent("(new value: 20)");
        this.assertTextPresent("(new value: 420)");
        this.assertTextPresent("(new value: ssl)");
        this.assertTextInElement("initialSize", "1");
        this.assertTextInElement("preferredSize", "10");
        this.assertTextInElement("maximumSize", "20");
        this.assertTextInElement("timeoutInSec", "420");
        this.assertTextInElement("supportedProtocol", "ssl");
        this.assertTextInElement("supportedAuthentication", "simple");
        this.gotoLdapConnectionPool();
        this.checkDefaultValues();
    }

    public void testInvalidAuthenticationType() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("maximumSize", "20");
        this.setTextField("timeoutInSec", "420");
        this.setTextField("supportedProtocol", "ssl");
        this.setTextField("supportedAuthentication", "simple rhubarb");
        this.submit();
        this.assertErrorPresentWithKey("connectionpool.supportedAuthentication.error");
        this.assertErrorPresentWithKey("connectionpool.update.error");
        this.assertTextNotPresent("(new value: simple rhubarb)");
        this.assertTextPresent("(new value: 20)");
        this.assertTextPresent("(new value: 420)");
        this.assertTextPresent("(new value: ssl)");
        this.assertTextInElement("initialSize", "1");
        this.assertTextInElement("preferredSize", "10");
        this.assertTextInElement("maximumSize", "20");
        this.assertTextInElement("timeoutInSec", "420");
        this.assertTextInElement("supportedProtocol", "ssl");
        this.assertTextInElement("supportedAuthentication", "simple");
        this.gotoLdapConnectionPool();
        this.checkDefaultValues();
    }

    public void testInvalidProtocolType() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("initialSize", "2");
        this.setTextField("maximumSize", "20");
        this.setTextField("timeoutInSec", "420");
        this.setTextField("supportedProtocol", "ssl plane");
        this.submit();
        this.assertErrorPresentWithKey("connectionpool.supportedProtocol.error");
        this.assertErrorPresentWithKey("connectionpool.update.error");
        this.assertTextNotPresent("(new value: ssl plane)");
        this.assertTextPresent("(new value: 2)");
        this.assertTextPresent("(new value: 20)");
        this.assertTextPresent("(new value: 420)");
        this.assertTextInElement("initialSize", "2");
        this.assertTextInElement("preferredSize", "10");
        this.assertTextInElement("maximumSize", "20");
        this.assertTextInElement("timeoutInSec", "420");
        this.assertTextInElement("supportedProtocol", "plain ssl");
        this.assertTextInElement("supportedAuthentication", "simple");
        this.gotoLdapConnectionPool();
        this.checkDefaultValues();
    }

    public void testValidChange() {
        this.gotoLdapConnectionPool();
        this.assertKeyPresent("connectionpool.title");
        this.checkDefaultValues();
        this.setTextField("initialSize", "5");
        this.setTextField("maximumSize", "20");
        this.setTextField("timeoutInSec", "420");
        this.setTextField("supportedProtocol", "ssl");
        this.submit();
        this.assertTextInElement("initialSize", "5");
        this.assertTextInElement("preferredSize", "10");
        this.assertTextInElement("maximumSize", "20");
        this.assertTextInElement("timeoutInSec", "420");
        this.assertTextInElement("supportedProtocol", "ssl");
        this.assertTextInElement("supportedAuthentication", "simple");
        this.assertTextPresent("(new value: 5)");
        this.assertTextPresent("(new value: 20)");
        this.assertTextPresent("(new value: 420)");
        this.assertTextPresent("(new value: ssl)");
        this.assertTextNotPresent("(new value: 10)");
        this.assertTextNotPresent("(new value: simple)");
        this.resetToDefaults();
    }

    private void checkDefaultValues() {
        this.assertKeyPresent("connectionpool.initialSize.label");
        this.assertKeyPresent("connectionpool.initialSize.description");
        this.assertKeyPresent("connectionpool.preferredSize.label");
        this.assertKeyPresent("connectionpool.preferredSize.description");
        this.assertKeyPresent("connectionpool.maximumSize.label");
        this.assertKeyPresent("connectionpool.maximumSize.description");
        this.assertKeyPresent("connectionpool.timeout.label");
        this.assertKeyPresent("connectionpool.timeout.description");
        this.assertKeyPresent("connectionpool.supportedProtocol.label");
        this.assertKeyPresent("connectionpool.supportedProtocol.description");
        this.assertKeyPresent("connectionpool.supportedAuthentication.label");
        this.assertKeyPresent("connectionpool.supportedAuthentication.description");
        this.assertTextInElement("initialSize", "1");
        this.assertTextInElement("preferredSize", "10");
        this.assertTextInElement("maximumSize", "0");
        this.assertTextInElement("timeoutInSec", TIMEOUT_IN_SECONDS);
        this.assertTextInElement("supportedProtocol", "plain ssl");
        this.assertTextInElement("supportedAuthentication", "simple");
    }

    private void resetToDefaults() {
        this.setTextField("initialSize", "1");
        this.setTextField("preferredSize", "10");
        this.setTextField("maximumSize", "0");
        this.setTextField("timeoutInSec", TIMEOUT_IN_SECONDS);
        this.setTextField("supportedProtocol", "plain ssl");
        this.setTextField("supportedAuthentication", "simple");
        this.submit();
    }
}

