/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OGNLDoubleEvaluationTest
extends CrowdAcceptanceTestCase {
    public void testUsingAStringParameter() {
        this.restoreBaseSetup();
        this._loginAdminUser();
        String token = this.findCsrfToken();
        this.gotoPage("/console/secure/user/update.action?directoryID=32769&name=${\"foo\"%2B\"bar\"}&atl_token=" + token);
        this.assertTextPresent("${\"foo\"+\"bar\"}");
        this.assertTextNotPresent("foobar");
    }

    public void testUsingANonStringParameter() {
        this.restoreBaseSetup();
        this._loginAdminUser();
        String token = this.findCsrfToken();
        this.gotoPage("/console/secure/user/update!updateGeneral.action?directoryID=${32769}&name=admin&atl_token=" + token);
        this.assertKeyPresent("menu.viewprincipal.label");
        this.assertTextPresent("Directory <-1> does not exist");
    }

    public void testUsingANonSettableParameter() {
        this.gotoPage("/console/setup/selectsetupstep.action?currentStep=${@java.lang.System@exit(0)}");
        this.assertTextPresent("Your crowd installation is already setup");
    }

    private String findCsrfToken() {
        this.gotoViewPrincipal("admin", "Test Internal Directory");
        Matcher m = Pattern.compile("name=\\\"atl_token\\\"(\\W)*value=\\\"(.*)\\\"").matcher(this.getPageSource());
        OGNLDoubleEvaluationTest.assertTrue((boolean)m.find());
        return m.group(2);
    }
}

