/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.SetupCrowdTest;

public class LicenseMaintenanceTest
extends CrowdAcceptanceTestCase {
    private static final String LICENSE_ACTION = "/console/license.action";
    private static final String REGULAR_USER_NAME = "regularuser";
    private static final String REGULAR_USER_PASSWORD = "regularuser";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("restsetup.xml");
    }

    public void testShouldNotInstallUnparseableLicense() {
        this.gotoPage(LICENSE_ACTION);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.setTextField("key", "unparseable license");
        this.submit();
        this.assertKeyPresent("license.key.error.invalid");
    }

    public void testShouldNotInstallAnExpiredLicense() {
        this.gotoPage(LICENSE_ACTION);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.setTextField("key", "AAABFw0ODAoPeNp9kFFLwzAQx9/zKQI+t7TbZGUQEJc4CnWdrlMRX2J607A0LZe0um9vu3UgPvh4x\n/1+97+7eoaSbqGh0ZTGk8VssrieUrEt6CSKEsLBKdSN17VlS6y/yrcF5dCBqRtAooZOKJXXHTCPL\nZAlghyGufTAesM8iJIgismytr6fW8sKmDISD+EBrL8ppTbHxkgLPlR1NQozrcA6KI4NnAAunkSWb\n8TjRSPue+4/j+ikaU9B2F4aB6QHrAcrrQLx3Wg8XgImY8AcP6TV7szwQUc3Jx/ZAnaAKWe3xWwVr\nHbpXfCSP8yDnL+mY+B1W70D5vudA3QsiMl4QQ9lKb9Uvxa31uhKeyjJpkX1KR38fdgPj3SKEjAsA\nhQDnIHlSx5Ug4jClePbHxCPTYAwnQIUeTzFHGkn0bRuxJZNK5uaXO7y+uU=X02e6");
        this.submit();
        this.assertKeyPresent("license.key.error.maintenance.expired");
    }

    public void testShouldValidateCredentialsToUpdateLicense() {
        this.gotoPage(LICENSE_ACTION);
        this.setTextField("username", "admin");
        this.setTextField("password", "badpassword");
        if (SetupCrowdTest.useDeveloperLicense()) {
            this.setTextField("key", "AAABgQ0ODAoPeNp1kstuwjAQRff5CktdB4XXAqQsIHELLS+RQCvUjWMGcBvsaJxA+fuaQNQkopJX1\n9d3zsz4aaokCSAhzQ5pdvutVr/dJTQISctxelbEjpFSjYngIDXQrUiFki6dhXS5WI4Dau2EPsAFC\nkd4ScB9Nhq9wGef+HCCWCWAFo/VCbBi83Kp4pplxwhwvltpQO12La7krsF4Kk7gppiBtciQH5gGn\n6XgXgltc5odq5Q7Y0dwfbqmk/mCLosb+pMIvOTPFu1R0Vc5OgA0OGPfHb70Qvtjte7Yb5vNyB46z\nXfrSyCrwL+OlwNCZQqYoNC1Xq/UlU6NEGcg+QNf0bIXZ9qkzdQWtOvUBp+nDHPpv6Jlwgd74phxE\ncXVRXl3sRI0ZcJUkMzQ1obGUZ23tQCjVF7fb80YV/JbqrO05rhnUmiWEw3SmGktmPwDKu/AQ8h99\nfXeKpedxb8raz5ojiLJC4WgUxLfYMhOIUnibC8k2Rak+jax8vv7Hy1Lv3FyG1gwLAIUHEP4zbqEf\n1DeOWKb7SpxQ1MEd8ACFGxZV5doE27OtsuNDT50k2xIhAozX02im");
        } else {
            this.setTextField("key", "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm");
        }
        this.submit();
        this.assertKeyPresent("login.failed.invalidcredentials");
    }

    public void testRegularUserShouldNotBeAbleToUpdateValidLicense() {
        this.gotoPage(LICENSE_ACTION);
        this.setTextField("username", "regularuser");
        this.setTextField("password", "regularuser");
        if (SetupCrowdTest.useDeveloperLicense()) {
            this.setTextField("key", "AAABgQ0ODAoPeNp1kstuwjAQRff5CktdB4XXAqQsIHELLS+RQCvUjWMGcBvsaJxA+fuaQNQkopJX1\n9d3zsz4aaokCSAhzQ5pdvutVr/dJTQISctxelbEjpFSjYngIDXQrUiFki6dhXS5WI4Dau2EPsAFC\nkd4ScB9Nhq9wGef+HCCWCWAFo/VCbBi83Kp4pplxwhwvltpQO12La7krsF4Kk7gppiBtciQH5gGn\n6XgXgltc5odq5Q7Y0dwfbqmk/mCLosb+pMIvOTPFu1R0Vc5OgA0OGPfHb70Qvtjte7Yb5vNyB46z\nXfrSyCrwL+OlwNCZQqYoNC1Xq/UlU6NEGcg+QNf0bIXZ9qkzdQWtOvUBp+nDHPpv6Jlwgd74phxE\ncXVRXl3sRI0ZcJUkMzQ1obGUZ23tQCjVF7fb80YV/JbqrO05rhnUmiWEw3SmGktmPwDKu/AQ8h99\nfXeKpedxb8raz5ojiLJC4WgUxLfYMhOIUnibC8k2Rak+jax8vv7Hy1Lv3FyG1gwLAIUHEP4zbqEf\n1DeOWKb7SpxQ1MEd8ACFGxZV5doE27OtsuNDT50k2xIhAozX02im");
        } else {
            this.setTextField("key", "MprrTWaDMMgqqQFpjxNimIQipnxxoLHCfBhpuriOFeiHJo\nmi2Kf0GbDqztZI94<4TFAhw72Kl7Ojoz6JPyOhv<sLxwCc\nnMRVURrNpmqPrQoorqVTqomnMqQoOOQQnUVSvsxTtwVuWS\nmOnnqsmvUUnurtvvoqmmmmmUUnurtvvoqmmmmmUU1qiXpp\nfXkUUnmmmm");
        }
        this.submit();
        this.assertKeyPresent("login.failed.invalidcredentials");
    }

    public void testInformationIsNotVisibleToAnonymousUser() {
        this._logout();
        this.gotoPage(LICENSE_ACTION);
        this.assertKeyPresent("license.title");
        this.assertLicenseAndServerInformationNotPresent();
    }

    public void testInformationIsNotVisibleToRegularUser() {
        this._loginAsUser("regularuser", "regularuser");
        this.gotoPage(LICENSE_ACTION);
        this.assertKeyPresent("license.title");
        this.assertLicenseAndServerInformationNotPresent();
    }

    public void testInformationIsVisibleToAdmin() {
        this._loginAdminUser();
        this.gotoPage(LICENSE_ACTION);
        this.assertKeyPresent("license.title");
        this.assertLicenseAndServerInformationPresent();
    }

    private void assertLicenseAndServerInformationPresent() {
        this.assertKeyPresent("license.organization.label");
        this.assertKeyPresent("license.type.label");
        this.assertKeyPresent("license.sen.label");
        this.assertKeyPresent("license.supportperiod.label");
        this.assertKeyPresent("license.userlimit.label");
        this.assertKeyPresent("license.userresources.label");
        this.assertKeyPresent("systeminfo.serverid.label");
    }

    private void assertLicenseAndServerInformationNotPresent() {
        this.assertKeyNotPresent("license.organization.label");
        this.assertKeyNotPresent("license.type.label");
        this.assertKeyNotPresent("license.datepurchased.label");
        this.assertKeyNotPresent("license.sen.label");
        this.assertKeyNotPresent("license.supportperiod.label");
        this.assertKeyNotPresent("license.partner.label");
        this.assertKeyNotPresent("license.userlimit.label");
        this.assertKeyNotPresent("license.userresources.label");
        this.assertKeyNotPresent("systeminfo.serverid.label");
    }
}

