/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestResult;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.junit.Assert;

public class LdifLoaderForTesting {
    private final String baseUrl;

    public LdifLoaderForTesting(String baseUrl) {
        this.baseUrl = baseUrl;
        Assert.assertTrue((boolean)baseUrl.endsWith("/crowd"));
    }

    public void setLdif(InputStream in) throws IOException {
        String contentUrl = this.baseUrl.replaceAll("/crowd$", "/apacheds15/content");
        InputStreamRequestEntity entity = new InputStreamRequestEntity(in, "application/octet-stream");
        PostMethod pm = new PostMethod(contentUrl);
        pm.setRequestEntity((RequestEntity)entity);
        HttpClient hc = new HttpClient();
        hc.executeMethod((HttpMethod)pm);
        Assert.assertEquals((long)200L, (long)pm.getStatusCode());
    }

    public Test createRestoreTest(final InputStream in) {
        return new Test(){

            public int countTestCases() {
                return 1;
            }

            public void run(TestResult result) {
                result.startTest((Test)this);
                try {
                    LdifLoaderForTesting.this.setLdif(in);
                    result.endTest((Test)this);
                }
                catch (IOException e) {
                    result.addError((Test)this, (Throwable)e);
                }
            }
        };
    }

    public static Test createRestoreTest(Class<?> testClass, String resourceName) {
        InputStream in = testClass.getResourceAsStream(resourceName);
        Assert.assertNotNull((Object)in);
        return new LdifLoaderForTesting(CrowdAcceptanceTestCase.HOST_PATH).createRestoreTest(in);
    }
}

