/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.acceptance.tests.applications.crowd.LdifLoaderForTesting;
import com.atlassian.crowd.directory.ApacheDS15;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsEmptyIterable;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.junit.Assert;

public class DelegatedDirectoryWithNestedGroupsTest
extends CrowdAcceptanceTestCase {
    private static final String DELEGATED_DIRECTORY_NAME = "Test Delegated Directory";
    private static boolean ldifSetup = false;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("basesetup.xml");
        if (!ldifSetup) {
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("DelegatedDirectoryWithNestedGroupsTest-entries.ldif");
            DelegatedDirectoryWithNestedGroupsTest.assertNotNull((Object)in);
            new LdifLoaderForTesting(this.getBaseUrl()).setLdif(in);
            ldifSetup = true;
        }
    }

    void createDelegatingDirectory(boolean synchroniseGroupMemberships, boolean useNestedGroups) {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS15.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:12389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.setTextField("readTimeoutInSec", "42000");
        this.assertCheckboxNotSelected("useNestedGroups");
        if (synchroniseGroupMemberships) {
            this.checkCheckbox("importGroups");
        }
        if (useNestedGroups) {
            this.checkCheckbox("useNestedGroups");
        }
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)DELEGATED_DIRECTORY_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDirectoryToCrowdApplication() {
        this.gotoBrowseApplications();
        this.setScriptingEnabled(true);
        try {
            this.clickLinkWithExactText("crowd");
            this.clickLink("application-directories");
            this.setWorkingForm("directoriesForm");
            this.selectOption("unsubscribedDirectoriesID", DELEGATED_DIRECTORY_NAME);
            this.clickButton("add-directory");
        }
        finally {
            this.setScriptingEnabled(false);
        }
        this.selectOption("directory2-allowAll", "True");
        this.submit();
    }

    void assertNoUsersPresentInTestDirectory() {
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsEmptyIterable.emptyIterable());
    }

    void attemptAuthentication(String username, String password) {
        this.gotoViewApplication("crowd");
        this.clickLink("application-authtest");
        this.setWorkingForm("app-auth-test-form");
        this.setTextField("testUsername", username);
        this.setTextField("testPassword", password);
        this.submit();
        this.assertTextPresent("Successful verification");
    }

    List<Group> getGroupDetailsTableContents() {
        return this.scrapeTable("group-details", (List<String>)ImmutableList.of((Object)"Name", (Object)"Active", (Object)"Action"), new Function<List<String>, Group>(){

            public Group apply(List<String> input) {
                String groupName = input.get(0);
                String active = input.get(1);
                GroupTemplate group = new GroupTemplate(groupName, -1L);
                group.setActive(Boolean.parseBoolean(active));
                return group;
            }
        });
    }

    List<String> getGroupMemberUserNames() {
        return this.scrapeTable("view-group-users", (List<String>)ImmutableList.of((Object)"Username", (Object)"Email Address", (Object)"Active"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
    }

    List<String> getGroupMemberGroupNames() {
        return this.scrapeTable("view-group-groups", (List<String>)ImmutableList.of((Object)"Group Name", (Object)"Description", (Object)"Active"), new Function<List<String>, String>(){

            public String apply(List<String> input) {
                return input.get(0);
            }
        });
    }

    void browseTestDirectoryGroups() {
        this.gotoBrowseGroups();
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
    }

    public void testDelegatedDirectoryAuthenticateCreatesUserInUnderlyingInternalDirectory() {
        this.intendToModifyData();
        this.createDelegatingDirectory(false, false);
        this.assertNoUsersPresentInTestDirectory();
        this.addDirectoryToCrowdApplication();
        this.attemptAuthentication("user1", "password");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(this.userWithDetails("user1", "User 1")));
        this.browseTestDirectoryGroups();
        Assert.assertThat(this.getGroupDetailsTableContents(), (Matcher)IsEmptyIterable.emptyIterable());
    }

    void gotoViewGroupDirectMembers(String groupName, String directoryName) {
        this.gotoViewGroup(groupName, directoryName);
        this.clickLink("view-group-users");
    }

    public void testDelegatedDirectoryAuthenticateAddsUsersToGroupsInUnderlyingInternalDirectory() {
        this.intendToModifyData();
        this.createDelegatingDirectory(true, false);
        this.assertNoUsersPresentInTestDirectory();
        this.addDirectoryToCrowdApplication();
        this.attemptAuthentication("user1", "password");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(this.userWithDetails("user1", "User 1")));
        this.browseTestDirectoryGroups();
        Assert.assertThat(DelegatedDirectoryWithNestedGroupsTest.namesOf(this.getGroupDetailsTableContents()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept"}));
        this.gotoViewGroupDirectMembers("users-dept", DELEGATED_DIRECTORY_NAME);
        this.assertTableNotPresent("view-group-groups");
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user1"}));
        this.attemptAuthentication("user2", "password");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{this.userWithDetails("user1", "User 1"), this.userWithDetails("user2", "User 2")}));
        this.browseTestDirectoryGroups();
        Assert.assertThat(DelegatedDirectoryWithNestedGroupsTest.namesOf(this.getGroupDetailsTableContents()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept", "users-all"}));
        this.gotoViewGroupDirectMembers("users-dept", DELEGATED_DIRECTORY_NAME);
        this.assertTableNotPresent("view-group-groups");
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user1"}));
        this.gotoViewGroupDirectMembers("users-all", DELEGATED_DIRECTORY_NAME);
        this.assertTableNotPresent("view-group-groups");
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user2"}));
    }

    public void testDelegatedDirectoryAuthenticateAddsUsersToNestedGroupsInUnderlyingInternalDirectory() {
        this.intendToModifyData();
        this.createDelegatingDirectory(true, true);
        this.assertNoUsersPresentInTestDirectory();
        this.addDirectoryToCrowdApplication();
        this.attemptAuthentication("user1", "password");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(this.userWithDetails("user1", "User 1")));
        this.browseTestDirectoryGroups();
        Assert.assertThat(DelegatedDirectoryWithNestedGroupsTest.namesOf(this.getGroupDetailsTableContents()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept", "users-all"}));
        this.gotoViewGroupDirectMembers("users-dept", DELEGATED_DIRECTORY_NAME);
        this.assertTableNotPresent("view-group-groups");
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user1"}));
        this.gotoViewGroupDirectMembers("users-all", DELEGATED_DIRECTORY_NAME);
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept"}));
        this.assertTableNotPresent("view-group-users");
        this.attemptAuthentication("user2", "password");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Matcher[])new Matcher[]{this.userWithDetails("user1", "User 1"), this.userWithDetails("user2", "User 2")}));
        this.browseTestDirectoryGroups();
        Assert.assertThat(DelegatedDirectoryWithNestedGroupsTest.namesOf(this.getGroupDetailsTableContents()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept", "users-all"}));
        this.gotoViewGroupDirectMembers("users-dept", DELEGATED_DIRECTORY_NAME);
        this.assertTableNotPresent("view-group-groups");
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user1"}));
        this.gotoViewGroupDirectMembers("users-all", DELEGATED_DIRECTORY_NAME);
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept"}));
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user2"}));
    }

    public void testDelegatedDirectoryAuthenticateAddUsersToNestedGroupsWhenNestedGroupsAreEnabledAfterCreation() {
        this.intendToModifyData();
        this.createDelegatingDirectory(true, false);
        this.clickLinkWithExactText("Connector");
        this.assertCheckboxNotSelected("useNestedGroups");
        this.checkCheckbox("useNestedGroups");
        this.submit();
        this.assertCheckboxSelected("useNestedGroups");
        this.assertNoUsersPresentInTestDirectory();
        this.addDirectoryToCrowdApplication();
        this.attemptAuthentication("user1", "password");
        this.gotoBrowsePrincipals();
        this.setWorkingForm("searchusers");
        this.selectOption("directoryID", DELEGATED_DIRECTORY_NAME);
        this.submit();
        Assert.assertThat(this.getUserDetailsTableContents(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder(this.userWithDetails("user1", "User 1")));
        this.browseTestDirectoryGroups();
        Assert.assertThat(DelegatedDirectoryWithNestedGroupsTest.namesOf(this.getGroupDetailsTableContents()), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept", "users-all"}));
        this.gotoViewGroupDirectMembers("users-dept", DELEGATED_DIRECTORY_NAME);
        this.assertTableNotPresent("view-group-groups");
        Assert.assertThat(this.getGroupMemberUserNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"user1"}));
        this.gotoViewGroupDirectMembers("users-all", DELEGATED_DIRECTORY_NAME);
        Assert.assertThat(this.getGroupMemberGroupNames(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new String[]{"users-dept"}));
        this.assertTableNotPresent("view-group-users");
    }
}

