/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.user.CrowdUserConsoleAcceptenceTestCase;

public class ChangeExpiredPasswordTest
extends CrowdUserConsoleAcceptenceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.loadXmlOnSetUp("changepasswordfiltertest.xml");
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testViewChangePasswordWithPolicy() {
        this.log("Running testViewChangePasswordWithPolicy");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("principal.password.complexity.policy");
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
        this.assertKeyPresent("error.changepassword.required");
        this.assertWarningPresent();
        this.assertTextInElement("username", "joe");
        this.assertTextFieldEquals("originalPassword", "");
        this.assertTextFieldEquals("password", "");
        this.assertTextFieldEquals("confirmPassword", "");
    }

    public void testChangePasswordSuccessful() {
        this.intendToModifyData();
        this.log("Running testChangePasswordSuccessful");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("originalPassword", "joe");
        this.setTextField("password", "joesmith");
        this.setTextField("confirmPassword", "joesmith");
        this.submit();
        this.assertKeyPresent("passwordupdate.message");
        this._loginTestUser("joe", "joesmith");
        this.assertKeyPresent("menu.profile.label");
    }

    public void testChangePasswordOldPasswordBlank() {
        this.log("Running testChangePasswordOldPasswordBlank");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("password", "joesmith");
        this.setTextField("confirmPassword", "joesmith");
        this.submit();
        this.assertKeyPresent("password.invalid");
        this.assertKeyPresent("menu.user.console.changepassword.label");
    }

    public void testChangePasswordNewPasswordBlank() {
        this.log("Running testChangePasswordNewPasswordBlank");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("originalPassword", "joe");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passwordempty.invalid");
    }

    public void testChangePasswordNewPasswordDoesNotMatchDirectoryComplexityRequirements() {
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("originalPassword", "joe");
        this.setTextField("password", "PASSWORD-WITHOUT-LOWERCASE");
        this.setTextField("confirmPassword", "PASSWORD-WITHOUT-LOWERCASE");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passwordupdate.policy.error.message");
        this.assertTextPresent("Passwords <b>must</b> contain at least one lowercase character");
    }

    public void testChangePasswordNewPasswordMismatch() {
        this.log("Running testChangePasswordNewPasswordMismatch");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("originalPassword", "joe");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "somethingelse");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("passworddonotmatch.invalid");
    }

    public void testChangePasswordOldPasswordWrong() {
        this.log("Running testChangePasswordOldPasswordWrong");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("originalPassword", "wrong");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "new");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("password.invalid");
    }

    public void testChangePasswordAfterFailedAttempt() {
        this.intendToModifyData();
        this.log("Running testChangePasswordAfterFailedAttempt");
        this._logout();
        this._loginExpiredCredentialUser("joe", "joe");
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertTextInElement("username", "joe");
        this.setTextField("originalPassword", "wrong");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "new");
        this.submit();
        this.assertKeyPresent("menu.user.console.changepassword.label");
        this.assertKeyPresent("password.invalid");
        this.setTextField("originalPassword", "joe");
        this.setTextField("password", "new");
        this.setTextField("confirmPassword", "new");
        this.submit();
        this.assertKeyPresent("passwordupdate.message");
        this._loginTestUser("joe", "new");
        this.assertKeyPresent("menu.profile.label");
    }
}

