/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class BrowseGroupsTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.restoreCrowdFromXML("searchdirectories.xml");
    }

    public void testNoDirectoryIsSelectedByDefault() {
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
    }

    public void testDirectorySelectionIsSaved() {
        this.gotoBrowseGroups();
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", "Second Directory");
        this.assertSelectOptionNotPresent("directoryID", this.getText("selectdirectory.label"));
    }

    public void testNonExistingDirectorySelection() {
        this.gotoBrowseGroups();
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
        this.assertWarningAndErrorNotPresent();
    }

    public void testOnlyDirectoryIsSelected() {
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Apache DS");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Apache DS 1.5.4");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoBrowseGroups();
        this.assertSelectedOptionEquals("directoryID", "Test Internal Directory");
    }
}

