/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class AddGroupTest
extends CrowdAcceptanceTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        this._loginAdminUser();
        this.restoreCrowdFromXML("searchdirectories.xml");
    }

    public void testAddGroupWithNoDetails() {
        this.log("Running testAddGroupWithNoDetails");
        this.gotoAddGroup();
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.selectOptionByValue("directoryID", "-1");
        this.submit();
        this.assertKeyPresent("group.name.invalid");
        this.assertKeyPresent("group.directory.invalid");
    }

    public void testAddGroupThatAlreadyExists() {
        this.log("Running testAddGroupThatAlreadyExists");
        this.gotoAddGroup();
        this.setTextField("name", "crowd-administrators");
        this.setTextField("description", "Crowd Administrators");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("invalid.namealreadyexist");
    }

    public void testAddGroupWithTrailingWhitespaceFailsWithSpecificError() {
        this.log("Running testAddGroupThatAlreadyExists");
        this.gotoAddGroup();
        this.setTextField("name", "name ");
        this.setTextField("description", "Crowd Administrators");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("invalid.whitespace");
    }

    public void testAddGroupToInternalDirectory() {
        this.intendToModifyData();
        this.log("Running testAddGroupToInternalDirectory");
        this.gotoAddGroup();
        this.setTextField("name", "test-group");
        this.setTextField("description", "Crowd Test Group");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("test-group");
    }

    public void testAddGroupToInternalDirectoryMixedCaseName() {
        this.intendToModifyData();
        this.log("Running testAddGroupToInternalDirectoryInvalidName");
        this.gotoAddGroup();
        this.setTextField("name", "Test-Group");
        this.setTextField("description", "");
        this.selectOption("directoryID", "Test Internal Directory");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-Group");
    }

    public void testAddGroupToLDAPMixedCaseName() {
        this.intendToModifyData();
        this.intendToModifyLdapData();
        this.log("Running testAddGroupToLDAPMixedCaseName");
        this.gotoAddGroup();
        this.setTextField("name", "Test-MixedCase");
        this.setTextField("description", "");
        this.selectOption("directoryID", "Apache DS");
        this.submit();
        this.assertKeyPresent("menu.viewgroup.label");
        this.assertTextPresent("Test-MixedCase");
    }

    public void testNoDirectoryIsSelectedByDefault() {
        this.gotoAddGroup();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
    }

    public void testDirectorySelectionIsSaved() {
        this.gotoAddGroup();
        this.setTextField("name", "testgroup");
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoAddGroup();
        this.assertSelectedOptionEquals("directoryID", "Second Directory");
        this.assertSelectOptionNotPresent("directoryID", this.getText("selectdirectory.label"));
    }

    public void testNonExistingDirectorySelection() {
        this.intendToModifyData();
        this.gotoAddGroup();
        this.setTextField("name", "testgroup");
        this.selectOption("directoryID", "Second Directory");
        this.submit();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoAddGroup();
        this.assertSelectedOptionEquals("directoryID", this.getText("selectdirectory.label"));
        this.assertWarningAndErrorNotPresent();
    }

    public void testOnlyDirectoryIsSelected() {
        this.intendToModifyData();
        this.gotoBrowseDirectories();
        this.clickLinkWithText("Apache DS");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Apache DS 1.5.4");
        this.clickLink("remove-directory");
        this.submit();
        this.clickLinkWithText("Second Directory");
        this.clickLink("remove-directory");
        this.submit();
        this.gotoAddGroup();
        this.assertSelectedOptionEquals("directoryID", "Test Internal Directory");
    }
}

