/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import com.atlassian.crowd.directory.ApacheDS;
import com.atlassian.crowd.directory.ApacheDS15;
import com.atlassian.crowd.directory.AppleOpenDirectory;
import com.atlassian.crowd.directory.FedoraDS;
import com.atlassian.crowd.directory.GenericLDAP;
import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.OpenLDAP;
import com.atlassian.crowd.directory.OpenLDAPRfc2307;
import com.atlassian.crowd.directory.SunONE;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.sourceforge.jwebunit.api.IElement;

public class AddDirectoryTest
extends CrowdAcceptanceTestCase {
    private static final String INTERNAL_DIRECTORY_NAME = "Second Internal Directory";
    private static final String INTERNAL_DIRECTORY_DESCRIPTION = "Second Internal Directory Description";
    private static final String CROWD_DIRECTORY_NAME = "Test Remote Crowd Directory";
    private static final String CROWD_DIRECTORY_DESCRIPTION = "Test Remote Crowd Directory Description";
    private static final String CONNECTOR_DIRECTORY_NAME = "Test Connector Directory";
    private static final String CONNECTOR_DIRECTORY_DESCRIPTION = "Test Connector Directory Description";
    private static final String CUSTOM_DIRECTORY_NAME = "Test Custom Remote Directory";
    private static final String DELEGATED_DIRECTORY_NAME = "Test Delegated Remote Directory";
    private static final String DELEGATED_DIRECTORY_DESCRIPTION = "Test Delegated Remote Directory Description";
    private static final String BAD_CLASS_NAME = "com.atlassian.crowd.integration.connector.ApacheDS";
    private static final String INTERNAL_DIRECTORY_PASSWORD_COMPLEXITY_DESCRIPTION = "Test Password Complexity Description";
    private static final String INTERNAL_DIRECTORY_PASSWORD_REGEX = "[a-z]";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreBaseSetup();
    }

    @Override
    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testAddInternalDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-internal");
        this.assertKeyPresent("directoryinternalcreate.title");
        this.setWorkingForm("directoryinternal");
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.setTextField("description", INTERNAL_DIRECTORY_DESCRIPTION);
        this.setTextField("passwordRegex", INTERNAL_DIRECTORY_PASSWORD_REGEX);
        this.setTextField("passwordComplexityMessage", INTERNAL_DIRECTORY_PASSWORD_COMPLEXITY_DESCRIPTION);
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)INTERNAL_DIRECTORY_NAME));
        this.assertTextFieldEquals("name", INTERNAL_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", INTERNAL_DIRECTORY_DESCRIPTION);
        this.assertTextPresent("Crowd Internal Directory");
    }

    public void testAddInternalDirectoryHasAtlassianSecurityAsDefaultEncryption() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-internal");
        this.assertKeyPresent("directoryinternalcreate.title");
        this.setWorkingForm("directoryinternal");
        this.assertSelectedOptionEquals("userEncryptionMethod", "ATLASSIAN-SECURITY");
        this.setTextField("name", INTERNAL_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)INTERNAL_DIRECTORY_NAME));
        this.clickLinkWithExactText("Configuration");
        this.assertTextPresent("ATLASSIAN-SECURITY");
    }

    public void testAddRemoteCrowdDirectory_ShouldTestConnectionBeforeSaving() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "bad-application-name");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.submit();
        this.assertKeyPresent("directorycrowd.testconnection.invalid");
        this.setTextField("applicationName", "demo");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CROWD_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CROWD_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CROWD_DIRECTORY_DESCRIPTION);
        this.clickLink("crowd-connectiondetails");
        this.assertTextFieldEquals("url", this.getBaseUrl());
        this.assertTextFieldEquals("applicationName", "demo");
        this.assertTextFieldEquals("pollingIntervalInMin", "60");
    }

    public void testAddRemoteCrowdDirectory_ManualConnectionTestShouldRetainPassword() {
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "bad-application-name");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.invalid");
        this.setTextField("applicationName", "demo");
        this.clickButton("test-connection");
        this.assertKeyPresent("directorycrowd.testconnection.success");
    }

    public void testAddInactiveRemoteCrowdDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.uncheckCheckbox("active");
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "demo");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CROWD_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertElementNotPresent("lastsyncinfo");
        this.assertButtonNotPresent("synchroniseDirectoryButton");
    }

    public void testAddRemoteCrowdDirectoryWithVariousOptions() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-crowd");
        this.assertKeyPresent("directorycrowdcreate.title");
        this.setWorkingForm("directorycrowd");
        this.setTextField("name", CROWD_DIRECTORY_NAME);
        this.setTextField("description", CROWD_DIRECTORY_DESCRIPTION);
        this.assertCheckboxNotSelected("useNestedGroups");
        this.checkCheckbox("useNestedGroups");
        this.clickLinkWithExactText("Connection");
        this.setTextField("url", this.getBaseUrl());
        this.setTextField("applicationName", "demo");
        this.setTextField("applicationPassword", "password");
        this.setTextField("pollingIntervalInMin", "60");
        this.setTextField("httpTimeout", "12");
        this.setTextField("httpMaxConnections", "123");
        this.setTextField("httpProxyPort", "5432");
        this.setTextField("httpProxyUsername", "proxyuser");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CROWD_DIRECTORY_NAME));
        this.assertCheckboxSelected("useNestedGroups");
        this.clickLinkWithExactText("Connection");
        this.assertTextFieldEquals("httpTimeout", "12");
        this.assertTextFieldEquals("httpMaxConnections", "123");
        this.assertTextFieldEquals("httpProxyPort", "5432");
        this.assertTextFieldEquals("httpProxyUsername", "proxyuser");
    }

    private void setConnectorFieldsForLocalLdapDirectory() {
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
    }

    public void testAddConnectorSetDefaultValuesForConfigurationProperties() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", MicrosoftActiveDirectory.getStaticDirectoryType());
        this.clickLinkWithExactText("Configuration");
        this.assertTextFieldEquals("userFirstnameAttr", "givenName");
        this.assertTextFieldEquals("userGroupMemberAttr", "memberOf");
        this.assertTextFieldEquals("userMailAttr", "mail");
        this.assertTextFieldEquals("userNameAttr", "sAMAccountName");
        this.assertTextFieldEquals("userNameRdnAttr", "cn");
        this.assertTextFieldEquals("userLastnameAttr", "sn");
        this.assertTextFieldEquals("userDisplayNameAttr", "displayName");
        this.assertTextFieldEquals("userObjectClass", "user");
        this.assertTextFieldEquals("userPasswordAttr", "unicodePwd");
        this.assertTextFieldEquals("userObjectFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.assertTextFieldEquals("userExternalIdAttr", "objectGUID");
        this.assertTextFieldEquals("groupDescriptionAttr", "description");
        this.assertTextFieldEquals("groupMemberAttr", "member");
        this.assertTextFieldEquals("groupNameAttr", "cn");
        this.assertTextFieldEquals("groupObjectClass", "group");
        this.assertTextFieldEquals("groupObjectFilter", "(objectCategory=Group)");
    }

    public void testAddConnectorDirectoryWithUsernameAndPassword() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.setTextField("readTimeoutInSec", "42000");
        this.checkCheckbox("localGroupsEnabled");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("localGroupsEnabled");
        this.assertTextFieldEquals("readTimeoutInSec", "42000");
        this.assertTextFieldEquals("searchTimeoutInSec", "60");
        this.assertTextFieldEquals("connectionTimeoutInSec", "10");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "ou=groups");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
        this.assertCheckboxNotPresent("rolesDisabled");
    }

    public void testAddConnectorDirectoryWithAnonymousAccess() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "");
    }

    public void testTestConfigurationShouldPersistPassword() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("directoryconnector");
        this.selectOption("connector", OpenLDAP.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.selectOption("userEncryptionMethod", "MD5");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
        this.clickButton("test-connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testAddInactiveConnectorDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.uncheckCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.setTextField("readTimeoutInSec", "42000");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertElementNotPresent("lastsyncinfo");
        this.assertButtonNotPresent("synchroniseDirectoryButton");
    }

    public void testAddConnectorDirectoryWithPwdEncryption() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", CONNECTOR_DIRECTORY_NAME);
        this.setTextField("description", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.selectOption("userEncryptionMethod", "MD5");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CONNECTOR_DIRECTORY_NAME));
        this.setWorkingForm("updateGeneral");
        this.assertTextFieldEquals("name", CONNECTOR_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", CONNECTOR_DIRECTORY_DESCRIPTION);
        this.assertTextPresent(GenericLDAP.getStaticDirectoryType());
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "MD5");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "ou=groups");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
        this.assertCheckboxNotPresent("rolesDisabled");
    }

    public void testAddInternalDirectoryWithoutName() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-internal");
        this.assertKeyPresent("directoryinternalcreate.title");
        this.setWorkingForm("directoryinternal");
        this.setTextField("name", "");
        this.setTextField("description", INTERNAL_DIRECTORY_DESCRIPTION);
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
    }

    public void testAddConnectorDirectoryWithoutAttributes() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "");
        this.setTextField("groupObjectClass", "");
        this.setTextField("groupObjectFilter", "");
        this.setTextField("groupNameAttr", "");
        this.setTextField("groupDescriptionAttr", "");
        this.setTextField("groupMemberAttr", "");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userPasswordAttr", "");
        this.setTextField("userExternalIdAttr", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.clickLinkWithExactText("Connector");
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid.blank");
        this.clickLinkWithExactText("Configuration");
        this.assertKeyPresent("directoryconnector.groupobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.groupobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.groupname.invalid");
        this.assertKeyPresent("directoryconnector.groupmember.invalid");
        this.assertKeyPresent("directoryconnector.groupdescription.invalid");
        this.assertCheckboxNotPresent("rolesDisabled");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userpassword.invalid");
    }

    public void testAddConnectorDirectoryWithBadDnShowsSpecificError() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("baseDN", "invalid");
        this.submit();
        this.clickLinkWithExactText("Connector");
        this.assertKeyPresent("directoryconnector.basedn.invalid");
    }

    public void testAddConnectorDirectoryWithUseUserMembershipAttribute() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.clickLinkWithExactText("Configuration");
        this.checkCheckbox("useUserMembershipAttribute");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxSelected("useUserMembershipAttribute");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
        this.assertCheckboxNotPresent("rolesDisabled");
    }

    public void testAddConnectorDirectoryWithUseUserMembershipAttributeForGroupMembership() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "1");
        this.setTextField("description", "2");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.checkCheckbox("useUserMembershipAttributeForGroupMembership");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "7");
        this.setTextField("groupObjectClass", "8");
        this.setTextField("groupObjectFilter", "9");
        this.setTextField("groupNameAttr", "10");
        this.setTextField("groupDescriptionAttr", "11");
        this.setTextField("groupMemberAttr", "12");
        this.setTextField("userDNaddition", "19");
        this.setTextField("userObjectClass", "20");
        this.setTextField("userObjectFilter", "21");
        this.setTextField("userNameAttr", "22");
        this.setTextField("userFirstnameAttr", "23");
        this.setTextField("userLastnameAttr", "24");
        this.setTextField("userMailAttr", "25");
        this.setTextField("userGroupMemberAttr", "26");
        this.setTextField("userPasswordAttr", "27");
        this.submit();
        this.assertWarningNotPresent();
        this.assertErrorNotPresent();
        this.assertTextFieldEquals("name", "1");
        this.assertTextFieldEquals("directoryDescription", "2");
        this.clickLink("connector-connectiondetails");
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.assertCheckboxNotSelected("useUserMembershipAttribute");
        this.clickLink("connector-configuration");
        this.assertTextFieldEquals("groupDNaddition", "7");
        this.assertTextFieldEquals("groupObjectClass", "8");
        this.assertTextFieldEquals("groupObjectFilter", "9");
        this.assertTextFieldEquals("groupNameAttr", "10");
        this.assertTextFieldEquals("groupDescriptionAttr", "11");
        this.assertTextFieldEquals("groupMemberAttr", "12");
        this.assertTextFieldEquals("userDNaddition", "19");
        this.assertTextFieldEquals("userObjectClass", "20");
        this.assertTextFieldEquals("userObjectFilter", "21");
        this.assertTextFieldEquals("userNameAttr", "22");
        this.assertTextFieldEquals("userFirstnameAttr", "23");
        this.assertTextFieldEquals("userLastnameAttr", "24");
        this.assertTextFieldEquals("userMailAttr", "25");
        this.assertTextFieldEquals("userGroupMemberAttr", "26");
        this.assertTextFieldEquals("userPasswordAttr", "27");
        this.assertCheckboxNotPresent("rolesDisabled");
    }

    public void testAddConnectorDirectoryTestSearch() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("directoryconnector");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=groups");
        this.setTextField("groupObjectClass", "groupOfNames");
        this.setTextField("groupObjectFilter", "(objectclass=groupOfNames)");
        this.clickButton("test-search-group");
        this.assertKeyPresent("directoryconnector.testsearch.success");
    }

    public void testAddConnectorDirectoryTestSearchInvalid() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.clickLinkWithExactText("Connector");
        this.setWorkingForm("directoryconnector");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.clickLinkWithExactText("Configuration");
        this.setTextField("groupDNaddition", "ou=nonexistent");
        this.clickButton("test-search-group");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testAddCustomDirectoryWithoutAttributes() {
        this.gotoCreateDirectory();
        this.clickButton("create-custom");
        this.assertKeyPresent("directorycustomcreate.title");
        this.setWorkingForm("directorycustom");
        this.setTextField("name", "");
        this.setTextField("implementationClass", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.assertKeyPresent("directorycustom.implementationclass.invalid");
    }

    public void testAddCustomDirectoryWithBadImplementationClass() {
        this.gotoCreateDirectory();
        this.clickButton("create-custom");
        this.assertKeyPresent("directorycustomcreate.title");
        this.setWorkingForm("directorycustom");
        this.setTextField("name", CUSTOM_DIRECTORY_NAME);
        this.setTextField("implementationClass", BAD_CLASS_NAME);
        this.submit();
        this.assertErrorPresent();
        this.assertTextPresent("Could not find a directory instance loader for directory <com.atlassian.crowd.integration.connector.ApacheDS>");
        this.assertKeyPresent("directorycustom.implementationclass.invalid");
    }

    public void testAddCustomDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-custom");
        this.assertKeyPresent("directorycustomcreate.title");
        this.setWorkingForm("directorycustom");
        this.setTextField("name", CUSTOM_DIRECTORY_NAME);
        this.setTextField("implementationClass", ApacheDS.class.getCanonicalName());
        this.submit();
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.assertTextFieldEquals("name", CUSTOM_DIRECTORY_NAME);
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)CUSTOM_DIRECTORY_NAME));
    }

    public void testAddDelegatedDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertTextFieldEquals("name", DELEGATED_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", DELEGATED_DIRECTORY_DESCRIPTION);
        this.assertKeyPresent("directory.delegating.type.name");
        this.assertCheckboxSelected("active");
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)DELEGATED_DIRECTORY_NAME));
        this.clickLink("delegated-connectiondetails");
        this.assertTextPresent(ApacheDS.getStaticDirectoryType());
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("delegated-configuration");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
    }

    public void testTestConfigurationShouldPersistPasswordForDelegatedDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.selectOption("userEncryptionMethod", "MD5");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickButtonWithText("Test Connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
        this.clickButtonWithText("Test Connection");
        this.assertKeyPresent("directoryconnector.testconnection.success");
    }

    public void testAddDelegatedDirectoryWithPwdEncryption() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("description", DELEGATED_DIRECTORY_DESCRIPTION);
        this.checkCheckbox("active");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.setTextField("URL", "ldap://localhost:11389/");
        this.selectOption("userEncryptionMethod", "MD5");
        this.setTextField("baseDN", "dc=example,dc=com");
        this.setTextField("userDN", "uid=admin,ou=system");
        this.setTextField("ldapPassword", "secret");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertTextFieldEquals("name", DELEGATED_DIRECTORY_NAME);
        this.assertTextFieldEquals("directoryDescription", DELEGATED_DIRECTORY_DESCRIPTION);
        this.assertKeyPresent("directory.delegating.type.name");
        this.assertCheckboxSelected("active");
        this.assertKeyPresent("menu.viewdirectory.label", (List)ImmutableList.of((Object)DELEGATED_DIRECTORY_NAME));
        this.clickLink("delegated-connectiondetails");
        this.assertTextPresent(GenericLDAP.getStaticDirectoryType());
        this.assertTextFieldEquals("URL", "ldap://localhost:11389/");
        this.assertSelectedOptionEquals("userEncryptionMethod", "MD5");
        this.assertTextFieldEquals("baseDN", "dc=example,dc=com");
        this.assertTextFieldEquals("userDN", "uid=admin,ou=system");
        this.clickLink("delegated-configuration");
        this.assertTextFieldEquals("userDNaddition", "ou=users");
    }

    public void testAddDelegatingDirectoryWithoutAttributes() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", "");
        this.setTextField("description", "");
        this.clickLinkWithExactText("Connector");
        this.selectOption("connector", ApacheDS.getStaticDirectoryType());
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "");
        this.setTextField("userObjectClass", "");
        this.setTextField("userObjectFilter", "");
        this.setTextField("userNameAttr", "");
        this.setTextField("userNameRdnAttr", "");
        this.setTextField("userDisplayNameAttr", "");
        this.setTextField("userFirstnameAttr", "");
        this.setTextField("userLastnameAttr", "");
        this.setTextField("userMailAttr", "");
        this.setTextField("userGroupMemberAttr", "");
        this.setTextField("userExternalIdAttr", "");
        this.submit();
        this.assertKeyPresent("directoryinternal.name.invalid");
        this.clickLinkWithExactText("Connector");
        this.assertKeyPresent("directoryconnector.url.invalid");
        this.assertKeyNotPresent("directoryconnector.basedn.invalid");
        this.assertKeyPresent("directoryconnector.basedn.invalid.blank");
        this.clickLinkWithExactText("Configuration");
        this.assertKeyPresent("directoryconnector.userobjectclass.invalid");
        this.assertKeyPresent("directoryconnector.userobjectfilter.invalid");
        this.assertKeyPresent("directoryconnector.usernameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usernamerdnattribute.invalid");
        this.assertKeyPresent("directoryconnector.userfirstnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.userlastnameattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermailattribute.invalid");
        this.assertKeyPresent("directoryconnector.usermemberofattribute.invalid");
        this.assertKeyPresent("directoryconnector.userdisplaynameattribute.invalid");
    }

    public void testAddDelegatedDirectoryTestSearch() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.success");
    }

    public void testAddDelegatedDirectoryTestSearchInvalid() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.clickLinkWithExactText("Connector");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=nonexistent");
        this.clickButton("test-search-principal");
        this.assertKeyPresent("directoryconnector.testsearch.invalid");
    }

    public void testAddDelegatedDirectoryPageResultsEnabledForActiveDirectory() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("baseDN", "dc=example,dc=com");
        this.clickLinkWithExactText("Connector");
        this.assertCheckboxSelected("pagedResults");
        this.selectOption("connector", OpenLDAP.getStaticDirectoryType());
        this.assertCheckboxNotSelected("pagedResults");
        this.selectOption("connector", MicrosoftActiveDirectory.getStaticDirectoryType());
        this.assertCheckboxSelected("pagedResults");
    }

    public void testAddDelegatedDirectoryWithPagedResultsSpecified() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("baseDN", "dc=example,dc=com");
        this.clickLinkWithExactText("Connector");
        this.assertCheckboxSelected("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "999");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.checkCheckbox("pagedResults");
        this.setTextField("pagedResultsSize", "998");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertTextPresent("View Directory - Test Delegated Remote Directory");
        this.assertTextFieldEquals("name", DELEGATED_DIRECTORY_NAME);
        this.clickLinkWithExactText("Connector");
        this.assertCheckboxSelected("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "998");
    }

    public void testAddDelegatedDirectoryWithPagedResultsNotSpecified() {
        this.intendToModifyData();
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.setTextField("name", DELEGATED_DIRECTORY_NAME);
        this.setTextField("baseDN", "dc=example,dc=com");
        this.clickLinkWithExactText("Connector");
        this.assertCheckboxSelected("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "999");
        this.setConnectorFieldsForLocalLdapDirectory();
        this.uncheckCheckbox("pagedResults");
        this.setTextField("pagedResultsSize", "998");
        this.clickLinkWithExactText("Configuration");
        this.setTextField("userDNaddition", "ou=users");
        this.submit();
        this.assertTextPresent("View Directory - Test Delegated Remote Directory");
        this.assertTextFieldEquals("name", DELEGATED_DIRECTORY_NAME);
        this.clickLinkWithExactText("Connector");
        this.assertCheckboxNotSelected("pagedResults");
        this.assertTextFieldEquals("pagedResultsSize", "");
    }

    public void testBaseDNMandatoryForAllDirectoriesExceptGenericLDAP() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "Name");
        this.clickLinkWithExactText("Connector");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.assertBaseDnMandatoryForAllExceptGenericLDAP();
    }

    public void testBaseDnMandatoryForAllDirectoriesExceptGenericLDAPForDelegatedAuthentication() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", "Name");
        this.clickLinkWithExactText("Connector");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.assertBaseDnMandatoryForAllExceptGenericLDAP();
    }

    private void assertBaseDnMandatoryForAllExceptGenericLDAP() {
        this.assertBaseDNMandatory(ApacheDS.getStaticDirectoryType());
        this.assertBaseDNMandatory(ApacheDS15.getStaticDirectoryType());
        this.assertBaseDNMandatory(OpenLDAP.getStaticDirectoryType());
        this.assertBaseDNMandatory(MicrosoftActiveDirectory.getStaticDirectoryType());
        this.assertBaseDNMandatory(SunONE.getStaticDirectoryType());
        this.assertBaseDNMandatory(FedoraDS.getStaticDirectoryType());
        this.assertBaseDNMandatory(OpenLDAPRfc2307.getStaticDirectoryType());
        this.assertBaseDNMandatory(AppleOpenDirectory.getStaticDirectoryType());
    }

    private void assertBaseDNMandatory(String connector) {
        this.selectOption("connector", connector);
        this.submit();
        this.assertUnescapedKeyPresent("directoryconnector.basedn.invalid.blank");
    }

    public void testBaseDNOptionalForGenericLDAP() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.assertKeyPresent("directoryconnectorcreate.title");
        this.setWorkingForm("directoryconnector");
        this.setTextField("name", "Name");
        this.clickLinkWithExactText("Connector");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.submit();
        this.assertUnescapedKeyNotPresent("directoryconnector.basedn.invalid.blank");
        this.assertUnescapedKeyNotPresent("directoryconnector.basedn.invalid");
    }

    public void testBaseDNOptionalForGenericLDAPForDelegatedAuthentication() {
        this.gotoCreateDirectory();
        this.clickButton("create-delegating");
        this.assertKeyPresent("directory.delegated.create.title");
        this.setWorkingForm("directorydelegated");
        this.setTextField("name", "Name");
        this.clickLinkWithExactText("Connector");
        this.setTextField("URL", "");
        this.setTextField("baseDN", "");
        this.setTextField("userDN", "");
        this.setTextField("ldapPassword", "");
        this.selectOption("connector", GenericLDAP.getStaticDirectoryType());
        this.submit();
        this.assertUnescapedKeyNotPresent("directoryconnector.basedn.invalid.blank");
        this.assertUnescapedKeyNotPresent("directoryconnector.basedn.invalid");
    }

    public void testOnlyActiveDirectoryHasLocalUserStatusOption() {
        this.gotoCreateDirectory();
        this.clickButton("create-connector");
        this.clickLinkWithExactText("Connector");
        IElement localUserStatusDiv = this.getElementById("local_user_status");
        this.selectOption("connector", OpenLDAP.getStaticDirectoryType());
        AddDirectoryTest.assertEquals((String)"display: none;", (String)localUserStatusDiv.getAttribute("style"));
        this.selectOption("connector", MicrosoftActiveDirectory.getStaticDirectoryType());
        AddDirectoryTest.assertEquals((String)"display: block;", (String)localUserStatusDiv.getAttribute("style"));
    }
}

