/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests;

import com.atlassian.core.util.PropertyUtils;
import java.util.Properties;
import org.junit.Assert;

public class BaseUrlFromProperties {
    private final Properties specProperties;

    public BaseUrlFromProperties(Properties specProperties) {
        this.specProperties = specProperties;
    }

    public BaseUrlFromProperties() {
        this(new Properties());
    }

    public static BaseUrlFromProperties withLocalTestProperties() {
        Properties props = PropertyUtils.getProperties((String)"localtest.properties", BaseUrlFromProperties.class);
        Assert.assertNotNull((Object)props);
        return new BaseUrlFromProperties(props);
    }

    public String baseUrlFor(String applicationName) {
        String port = this.getTestProperty(applicationName + ".port");
        String context = this.getTestProperty(applicationName + ".context");
        String rootUrl = "http://" + this.getTestProperty("host.location") + ":" + port;
        return rootUrl + context;
    }

    private String getTestProperty(String propName) {
        if (System.getProperty("acceptance.test." + propName) != null) {
            return System.getProperty("acceptance.test." + propName);
        }
        if (this.specProperties.getProperty(propName) != null) {
            return this.specProperties.getProperty(propName);
        }
        throw new IllegalStateException("No test property found for: " + propName);
    }
}

