/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence.dao.membership;

import com.atlassian.crowd.acceptance.tests.persistence.BaseSpringTestCase;
import com.atlassian.crowd.dao.group.GroupDAOHibernate;
import com.atlassian.crowd.dao.membership.MembershipDAOHibernate;
import com.atlassian.crowd.dao.user.UserDAOHibernate;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.membership.InternalMembership;
import com.atlassian.crowd.model.user.InternalUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplateWithCredentialAndAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.util.BatchResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.dao.DataIntegrityViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipDAOHibernateTest
extends BaseSpringTestCase {
    private static final long DIRECTORY_ID = 1L;
    private MembershipDAOHibernate membershipDAO;
    private UserDAOHibernate userDAO;
    private GroupDAOHibernate groupDAO;
    private static final String ADMINISTRATORS_GROUP_MIXED = "Administrators";
    private static final String ADMINISTRATORS_GROUP_ACTUAL = "administratorS";
    private static final String USERS_ROLE = "users";
    private static final String DEVELOPERS_GROUP = "developers";
    private static final String ADMIN_USER = "aDmin";
    private static final String PRODUCT_MANAGERS_ROLE = "Product Managers";

    public void testIsUserDirectMemberTrueMixedCase() {
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isUserDirectMember(2L, "JohnSmith", "Testers"));
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isUserDirectMember(2L, "JohnSmith".toUpperCase(), "Testers"));
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isUserDirectMember(2L, "JohnSmith", "Testers".toUpperCase()));
    }

    public void testIsUserDirectMemberTrue() {
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", DEVELOPERS_GROUP));
    }

    public void testIsUserDirectMemberFalse() {
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "bob", USERS_ROLE));
    }

    public void testIsGroupDirectMemberTrue() {
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isGroupDirectMember(1L, PRODUCT_MANAGERS_ROLE, USERS_ROLE));
    }

    public void testIsGroupDirectMemberFalse() {
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, ADMINISTRATORS_GROUP_ACTUAL));
    }

    public void testAddUserToGroup() throws Exception {
        this.membershipDAO.addUserToGroup(1L, "jane", USERS_ROLE);
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isUserDirectMember(1L, "jane", USERS_ROLE));
    }

    public void testAddUserToGroupWhereMembershipExists() throws Exception {
        try {
            this.membershipDAO.addUserToGroup(2L, "johnSmith", "testers");
            this.flush();
            MembershipDAOHibernateTest.fail((String)"ConstraintViolationException expected");
        }
        catch (ConstraintViolationException e) {
        }
        catch (DataIntegrityViolationException dataIntegrityViolationException) {
            // empty catch block
        }
    }

    public void testAddUserToGroupWhereGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.addUserToGroup(1L, "jane", "fakers");
            MembershipDAOHibernateTest.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("jane").returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "jane", "fakers"));
    }

    public void testAddUserToGroupWhereUserDoesNotExist() throws Exception {
        try {
            this.membershipDAO.addUserToGroup(1L, "billy", USERS_ROLE);
            MembershipDAOHibernateTest.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException userNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "billy", USERS_ROLE));
    }

    public void testRemoveUserFromGroup() throws Exception {
        this.membershipDAO.removeUserFromGroup(1L, ADMIN_USER, ADMINISTRATORS_GROUP_MIXED);
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(ADMINISTRATORS_GROUP_MIXED).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, ADMIN_USER, ADMINISTRATORS_GROUP_MIXED));
    }

    public void testRemoveUserFromGroupWhereGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeUserFromGroup(1L, ADMIN_USER, "faker");
            MembershipDAOHibernateTest.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException e) {
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, ADMIN_USER, "faker"));
    }

    public void testRemoveUserFromGroupWhereUserDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeUserFromGroup(1L, "billy", ADMINISTRATORS_GROUP_MIXED);
            MembershipDAOHibernateTest.fail((String)"UserNotFoundException expected");
        }
        catch (UserNotFoundException e) {
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isUserDirectMember(1L, "billy", ADMINISTRATORS_GROUP_MIXED));
    }

    public void testRemoveGroupFromGroup() throws Exception {
        this.membershipDAO.removeGroupFromGroup(1L, PRODUCT_MANAGERS_ROLE, USERS_ROLE);
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(DEVELOPERS_GROUP).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, USERS_ROLE));
    }

    public void testRemoveGroupFromGroupWhereParentGroupDoesNotExist() throws Exception {
        try {
            this.membershipDAO.removeGroupFromGroup(1L, DEVELOPERS_GROUP, "faker");
            MembershipDAOHibernateTest.fail((String)"GroupNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, "faker"));
    }

    public void testRemoveGroupFromGroupWhereChildGroupDoesNotExist() {
        try {
            this.membershipDAO.removeGroupFromGroup(1L, "faker", DEVELOPERS_GROUP);
            MembershipDAOHibernateTest.fail((String)"GroupNotFoundException expected");
        }
        catch (MembershipNotFoundException membershipNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, "faker", DEVELOPERS_GROUP));
    }

    public void testAddGroupToGroup() throws Exception {
        this.membershipDAO.addGroupToGroup(1L, ADMINISTRATORS_GROUP_MIXED, DEVELOPERS_GROUP);
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(ADMINISTRATORS_GROUP_MIXED).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(DEVELOPERS_GROUP).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertTrue((boolean)this.membershipDAO.isGroupDirectMember(1L, ADMINISTRATORS_GROUP_MIXED, DEVELOPERS_GROUP));
    }

    public void testAddGroupToGroupWhereChildGroupDoesNotExist() {
        try {
            this.membershipDAO.addGroupToGroup(1L, "testers", DEVELOPERS_GROUP);
            MembershipDAOHibernateTest.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, "testers", DEVELOPERS_GROUP));
    }

    public void testAddGroupToGroupWhereParentGroupDoesNotExist() {
        try {
            this.membershipDAO.addGroupToGroup(1L, DEVELOPERS_GROUP, "testers");
            MembershipDAOHibernateTest.fail((String)"GroupNotFoundException expected");
        }
        catch (GroupNotFoundException groupNotFoundException) {
            // empty catch block
        }
        MembershipDAOHibernateTest.assertFalse((boolean)this.membershipDAO.isGroupDirectMember(1L, DEVELOPERS_GROUP, "testers"));
    }

    public void testRemoveGroupMembers() {
        this.membershipDAO.removeGroupMembers(1L, USERS_ROLE);
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
    }

    public void testRemoveGroupMemberships() {
        this.membershipDAO.removeGroupMemberships(1L, DEVELOPERS_GROUP);
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(DEVELOPERS_GROUP).returningAtMost(10)).size());
    }

    public void testRemoveUserMemberships() {
        this.membershipDAO.removeUserMemberships(1L, ADMIN_USER);
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
    }

    public void testRemoveAllRelationships() {
        this.membershipDAO.removeAllRelationships(1L);
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(DEVELOPERS_GROUP).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_membership where directory_id = 1"));
    }

    public void testRemoveUserRelationships() {
        this.membershipDAO.removeAllUserRelationships(1L);
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.jdbcTemplate.queryForInt("select count(*) from cwd_membership where membership_type = 'GROUP_USER' and directory_id = 1"));
    }

    public void testRenameUserRelationships() {
        this.membershipDAO.renameUserRelationships(1L, ADMIN_USER, "badmin");
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)2, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName("badmin").returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.user()).withName("badmin").returningAtMost(10)).size());
    }

    public void testRenameGroupRelationships() {
        this.membershipDAO.renameGroupRelationships(1L, USERS_ROLE, "lusers");
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)0, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("lusers").returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName("lusers").returningAtMost(10)).size());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.role()).withName(PRODUCT_MANAGERS_ROLE).returningAtMost(10)).size());
    }

    public void testSearchForUserMembersOfGroup() {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, IdentifierUtils.toLowerCase((String)ADMIN_USER));
    }

    public void testSearchForUserMembersOfGroupAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, IdentifierUtils.toLowerCase((String)ADMIN_USER));
    }

    public void testSearchForGroupMembershipsOfUser() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, ADMINISTRATORS_GROUP_ACTUAL, DEVELOPERS_GROUP);
    }

    public void testSearchForGroupMembershipsOfUserAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, ADMINISTRATORS_GROUP_ACTUAL, DEVELOPERS_GROUP);
    }

    public void testSearchForGroupMembershipsOfGroup() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.role()).withName(PRODUCT_MANAGERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, USERS_ROLE);
    }

    public void testSearchForGroupMembershipsOfGroupAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.role()).parentsOf(EntityDescriptor.role()).withName(PRODUCT_MANAGERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, USERS_ROLE);
    }

    public void testSearchForGroupMembersOfGroup() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, PRODUCT_MANAGERS_ROLE);
    }

    public void testSearchForGroupMembersOfGroupAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.role()).childrenOf(EntityDescriptor.role()).withName(USERS_ROLE).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, PRODUCT_MANAGERS_ROLE);
    }

    public void testSearchForUserMembersOfGroupOfTypeRole() {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, new String[0]);
    }

    public void testSearchForUserMembersOfGroupOfTypeRoleAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(ADMINISTRATORS_GROUP_MIXED).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, new String[0]);
    }

    public void testSearchForGroupMembershipsOfUserOfTypeRole() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, USERS_ROLE);
    }

    public void testSearchForGroupMembershipsOfUserOfTypeRoleAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.user()).withName(ADMIN_USER).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, USERS_ROLE);
    }

    public void testSearchForGroupMembershipsOfGroupOfTypeRole() {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(DEVELOPERS_GROUP).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, new String[0]);
    }

    public void testSearchForGroupMembershipsOfGroupOfTypeRoleAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).parentsOf(EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).withName(DEVELOPERS_GROUP).startingAt(0).returningAtMost(10);
        List results = this.membershipDAO.search(1L, query);
        this.assertContainsExactly(results, new String[0]);
    }

    public void testSearchForGroupMembersfGroupOfMismatchingTypesAsNames() {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName(USERS_ROLE).startingAt(0).returningAtMost(10);
        try {
            this.membershipDAO.search(1L, query);
            MembershipDAOHibernateTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddAll() throws Exception {
        int i;
        HashSet<UserTemplateWithCredentialAndAttributes> users = new HashSet<UserTemplateWithCredentialAndAttributes>();
        for (i = 0; i < 15; ++i) {
            UserTemplateWithCredentialAndAttributes user = new UserTemplateWithCredentialAndAttributes("user" + i, 1L, new PasswordCredential("secret", true));
            user.setEmailAddress("blah@example.com");
            user.setFirstName("Clone");
            user.setLastName("Drone");
            user.setDisplayName("Clone Drone");
            users.add(user);
        }
        this.userDAO.addAll(users);
        for (i = 0; i < 3; ++i) {
            GroupTemplate group = new GroupTemplate("group" + i, 1L, GroupType.LEGACY_ROLE);
            group.setDescription("description");
            this.groupDAO.add((Group)group);
        }
        List internalUsers = this.userDAO.search(1L, QueryBuilder.queryFor(InternalUser.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).startingWith((Object)"user")).returningAtMost(100));
        List internalGroups = this.groupDAO.search(1L, QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.role()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"group")).returningAtMost(100));
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        for (InternalUser user : internalUsers) {
            for (InternalGroup group : internalGroups) {
                memberships.add(new InternalMembership(group, user));
            }
        }
        BatchResult result = this.membershipDAO.addAll(memberships);
        MembershipDAOHibernateTest.assertEquals((int)45, (int)result.getTotalAttempted());
        MembershipDAOHibernateTest.assertEquals((int)45, (int)result.getTotalSuccessful());
        MembershipDAOHibernateTest.assertEquals((int)15, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("group0").returningAtMost(100)).size());
        MembershipDAOHibernateTest.assertEquals((int)15, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("group1").returningAtMost(100)).size());
        MembershipDAOHibernateTest.assertEquals((int)15, (int)this.membershipDAO.search(1L, QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.role()).withName("group2").returningAtMost(100)).size());
    }

    public void testAddAllWithDuplicates() throws Exception {
        HashSet<InternalMembership> memberships = new HashSet<InternalMembership>();
        InternalUser admin = this.userDAO.findByName(1L, "admin");
        InternalUser jane = this.userDAO.findByName(1L, "jane");
        InternalGroup administrators = this.groupDAO.findByName(1L, "administrators");
        memberships.add(new InternalMembership(administrators, jane));
        InternalMembership duplicate = new InternalMembership(administrators, admin);
        memberships.add(duplicate);
        BatchResult result = this.membershipDAO.addAll(memberships);
        MembershipDAOHibernateTest.assertEquals((int)2, (int)result.getTotalAttempted());
        MembershipDAOHibernateTest.assertEquals((int)1, (int)result.getTotalSuccessful());
        MembershipDAOHibernateTest.assertTrue((boolean)result.getFailedEntities().contains(duplicate));
    }

    @Override
    public String getSampleDataFileName() {
        return "sample-data.xml";
    }

    public void setMembershipDAO(MembershipDAOHibernate membershipDAO) {
        this.membershipDAO = membershipDAO;
    }

    public void setUserDAO(UserDAOHibernate userDAO) {
        this.userDAO = userDAO;
    }

    public void setGroupDAO(GroupDAOHibernate groupDAO) {
        this.groupDAO = groupDAO;
    }

    private void assertContainsExactly(Collection<?> entities, String ... entityNames) {
        MembershipDAOHibernateTest.assertEquals((int)entityNames.length, (int)entities.size());
        List<String> namesAsList = Arrays.asList(entityNames);
        for (Object entity : entities) {
            MembershipDAOHibernateTest.assertTrue((String)("Entity " + entity + " not found in " + Arrays.asList(entityNames)), (boolean)this.contains(entity, namesAsList));
        }
    }

    private boolean contains(Object entity, List<String> entityNames) {
        String entityName = null;
        entityName = entity instanceof DirectoryEntity ? ((DirectoryEntity)entity).getName() : entity.toString();
        return entityNames.contains(entityName);
    }
}

