/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.acceptance.tests.directory.ImmutableUser;
import com.atlassian.crowd.acceptance.tests.directory.MockSynchronisationStatusManager;
import com.atlassian.crowd.acceptance.tests.directory.ModelAssertions;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.SynchronisableDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.manager.directory.SynchronisationMode;
import com.atlassian.crowd.manager.directory.SynchronisationStatusManager;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalGroupsTest
extends BaseTest {
    private static final String LDAP_USER_NAME = "user1";
    private static final String LDAP_USER2_NAME = "user2";
    private static final String LDAP_USER3_NAME = "user3";
    private static final String LDAP_GROUP_NAME = "ldap-group";
    private static final String LDAP_GROUP2_NAME = "ldap-group2";
    private static final String LOCAL_GROUP_NAME = "local-group";
    private static final String LOCAL_GROUP2_NAME = "local-group2";
    private RemoteDirectory remoteDirectory;
    private RemoteDirectory ldapDirectory;
    private Group localGroup;
    private Group ldapGroup;

    @Override
    protected void configureDirectory(Properties directorySettings) {
        super.configureDirectory(directorySettings);
        this.directory.setAttribute("ldap.local.groups", Boolean.TRUE.toString());
        this.directory.setAttribute("com.atlassian.crowd.directory.sync.cache.enabled", Boolean.TRUE.toString());
    }

    @Override
    protected void loadTestData() throws Exception {
        this.remoteDirectory = this.directory.getImplementation();
        this.ldapDirectory = ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"ldapDirectoryInstanceLoader")).getDirectory((Directory)this.directory);
        ImmutableUser user = new ImmutableUser(this.directory.getId(), LDAP_USER_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        ImmutableUser user2 = new ImmutableUser(this.directory.getId(), LDAP_USER2_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        ImmutableUser user3 = new ImmutableUser(this.directory.getId(), LDAP_USER3_NAME, "Bob", "Smith", "Bob Smith", "bsmith@example.com");
        this.ldapDirectory.addUser(new UserTemplate((User)user), new PasswordCredential("password"));
        this.ldapDirectory.addUser(new UserTemplate((User)user2), new PasswordCredential("password"));
        this.ldapDirectory.addUser(new UserTemplate((User)user3), new PasswordCredential("password"));
        this.localGroup = this.remoteDirectory.addGroup(new GroupTemplate(LOCAL_GROUP_NAME, this.directory.getId().longValue()));
        this.remoteDirectory.addGroup(new GroupTemplate(LOCAL_GROUP2_NAME, this.directory.getId().longValue()));
        this.ldapGroup = this.ldapDirectory.addGroup(new GroupTemplate(LDAP_GROUP_NAME, this.directory.getId().longValue()));
        this.ldapDirectory.addGroup(new GroupTemplate(LDAP_GROUP2_NAME, this.directory.getId().longValue()));
        this.ldapDirectory.addUserToGroup(LDAP_USER2_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.addUserToGroup(LDAP_USER3_NAME, LDAP_GROUP2_NAME);
        this.ldapDirectory.addGroupToGroup(LDAP_GROUP_NAME, LDAP_GROUP2_NAME);
        this.synchronizeCache(this.remoteDirectory);
        this.remoteDirectory.addUserToGroup(LDAP_USER2_NAME, LOCAL_GROUP2_NAME);
        this.remoteDirectory.addUserToGroup(LDAP_USER3_NAME, LOCAL_GROUP2_NAME);
        this.remoteDirectory.addGroupToGroup(LOCAL_GROUP_NAME, LOCAL_GROUP2_NAME);
    }

    @Override
    protected void removeTestData() {
        this.removeUser(LDAP_USER_NAME);
        this.removeUser(LDAP_USER2_NAME);
        this.removeUser(LDAP_USER3_NAME);
        this.removeGroup(LOCAL_GROUP_NAME);
        this.removeGroup(LOCAL_GROUP2_NAME);
        try {
            this.ldapDirectory = ((DirectoryInstanceLoader)ContainerManager.getComponent((String)"ldapDirectoryInstanceLoader")).getDirectory((Directory)this.directory);
            this.ldapDirectory.removeGroup(LDAP_GROUP_NAME);
            this.ldapDirectory.removeGroup(LDAP_GROUP2_NAME);
        }
        catch (Exception e) {
            this.logger.debug((Object)e);
        }
    }

    private void synchronizeCache(RemoteDirectory remoteDirectory) throws OperationFailedException {
        ((SynchronisableDirectory)remoteDirectory).synchroniseCache(SynchronisationMode.FULL, (SynchronisationStatusManager)new MockSynchronisationStatusManager());
    }

    public void testFindLocalGroupByName() throws Exception {
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LOCAL_GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.localGroup, retrievedGroup);
    }

    public void testFindLdapGroupByName() throws Exception {
        Group retrievedGroup = this.remoteDirectory.findGroupByName(LDAP_GROUP_NAME);
        ModelAssertions.assertGroupsEqual(this.ldapGroup, retrievedGroup);
    }

    public void testAddUserToLocalGroup() throws Exception {
        this.remoteDirectory.addUserToGroup(LDAP_USER_NAME, LOCAL_GROUP_NAME);
        boolean isMember = this.remoteDirectory.isUserDirectGroupMember(LDAP_USER_NAME, LOCAL_GROUP_NAME);
        LocalGroupsTest.assertTrue((String)"should be a member", (boolean)isMember);
    }

    public void testAddUserToLdapGroupFails() throws Exception {
        try {
            this.remoteDirectory.addUserToGroup(LDAP_USER_NAME, LDAP_GROUP_NAME);
            LocalGroupsTest.fail((String)"Expected exception not thrown");
        }
        catch (ReadOnlyGroupException readOnlyGroupException) {
            // empty catch block
        }
    }

    public void testRemoveUserFromLocalGroup() throws Exception {
        this.remoteDirectory.addUserToGroup(LDAP_USER_NAME, LOCAL_GROUP_NAME);
        this.remoteDirectory.removeUserFromGroup(LDAP_USER_NAME, LOCAL_GROUP_NAME);
        boolean isMember = this.remoteDirectory.isUserDirectGroupMember(LDAP_USER_NAME, LOCAL_GROUP_NAME);
        LocalGroupsTest.assertFalse((String)"should no longer be a member", (boolean)isMember);
    }

    public void testRemoveUserFromLdapGroupFails() throws Exception {
        try {
            this.remoteDirectory.removeUserFromGroup(LDAP_USER_NAME, LDAP_GROUP_NAME);
            LocalGroupsTest.fail((String)"Expected exception not thrown");
        }
        catch (ReadOnlyGroupException readOnlyGroupException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAddLocalGroupToLocalGroup() throws Exception {
        Group childGroup = this.remoteDirectory.addGroup(new GroupTemplate("child-group", this.directory.getId().longValue()));
        try {
            this.remoteDirectory.addGroupToGroup(childGroup.getName(), LOCAL_GROUP_NAME);
            boolean isMember = this.remoteDirectory.isGroupDirectGroupMember(childGroup.getName(), LOCAL_GROUP_NAME);
            LocalGroupsTest.assertTrue((String)"should be a member", (boolean)isMember);
        }
        finally {
            this.removeGroup(childGroup.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRemoveLocalGroupFromLocalGroup() throws Exception {
        Group childGroup = this.remoteDirectory.addGroup(new GroupTemplate("child-group", this.directory.getId().longValue()));
        try {
            this.remoteDirectory.addGroupToGroup(childGroup.getName(), LOCAL_GROUP_NAME);
            boolean isMember = this.remoteDirectory.isGroupDirectGroupMember(childGroup.getName(), LOCAL_GROUP_NAME);
            LocalGroupsTest.assertTrue((String)"should be a member", (boolean)isMember);
            this.remoteDirectory.removeGroupFromGroup(childGroup.getName(), LOCAL_GROUP_NAME);
            isMember = this.remoteDirectory.isGroupDirectGroupMember(childGroup.getName(), LOCAL_GROUP_NAME);
            LocalGroupsTest.assertFalse((String)"should no longer be a member", (boolean)isMember);
        }
        finally {
            this.removeGroup(childGroup.getName());
        }
    }

    public void testCannotAddLocalGroupWithSameNameAsLdap() throws Exception {
        try {
            this.remoteDirectory.addGroup(new GroupTemplate(this.ldapGroup.getName(), this.directory.getId().longValue()));
            LocalGroupsTest.fail((String)"Expected exception not thrown: InvalidGroupException");
        }
        catch (InvalidGroupException invalidGroupException) {
            // empty catch block
        }
    }

    public void testCannotAddLocalGroupToLdapGroup() throws Exception {
        try {
            this.remoteDirectory.addGroupToGroup(LOCAL_GROUP_NAME, LDAP_GROUP_NAME);
            LocalGroupsTest.fail((String)"Expected exception not thrown");
        }
        catch (ReadOnlyGroupException readOnlyGroupException) {
            // empty catch block
        }
    }

    public void testCannotAddLdapGroupToLocalGroup() throws Exception {
        try {
            this.remoteDirectory.addGroupToGroup(LDAP_GROUP_NAME, LOCAL_GROUP_NAME);
            LocalGroupsTest.fail((String)"Expected exception not thrown");
        }
        catch (ReadOnlyGroupException readOnlyGroupException) {
            // empty catch block
        }
    }

    public void testSearchAllGroups() throws OperationFailedException {
        List groups = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(10));
        LocalGroupsTest.assertEquals((int)4, (int)groups.size());
    }

    public void testSearchAllGroupNamesWithRestrictions() throws OperationFailedException {
        List groupNames = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).startingAt(1).returningAtMost(2));
        LocalGroupsTest.assertEquals((int)2, (int)groupNames.size());
        LocalGroupsTest.assertTrue((groupNames.contains(LDAP_GROUP_NAME) || groupNames.contains(LDAP_GROUP2_NAME) ? 1 : 0) != 0);
        LocalGroupsTest.assertTrue((groupNames.contains(LOCAL_GROUP_NAME) || groupNames.contains(LOCAL_GROUP2_NAME) ? 1 : 0) != 0);
    }

    public void testSearchGroupsOnLdapOnlyAttributes() throws OperationFailedException {
        List groups = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)LDAP_GROUP_NAME), Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)LOCAL_GROUP_NAME)})).returningAtMost(10));
        LocalGroupsTest.assertEquals((int)2, (int)groups.size());
        ImmutableSet result = ImmutableSet.of((Object)((Group)groups.get(0)).getName(), (Object)((Group)groups.get(1)).getName());
        LocalGroupsTest.assertTrue((boolean)result.contains(LDAP_GROUP_NAME));
        LocalGroupsTest.assertTrue((boolean)result.contains(LOCAL_GROUP_NAME));
    }

    public void testSearchGroupNamesOnLdapOnlyAttribute() throws OperationFailedException {
        List groupnames = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).containing((Object)"2")).returningAtMost(10));
        LocalGroupsTest.assertEquals((int)2, (int)groupnames.size());
        LocalGroupsTest.assertTrue((boolean)groupnames.contains(LDAP_GROUP2_NAME));
        LocalGroupsTest.assertTrue((boolean)groupnames.contains(LOCAL_GROUP2_NAME));
    }

    private Set<String> asNames(Collection<? extends DirectoryEntity> entities) {
        HashSet<String> names = new HashSet<String>(entities.size());
        for (DirectoryEntity directoryEntity : entities) {
            names.add(directoryEntity.getName());
        }
        return names;
    }

    private <T> void assertSearchReturns(MembershipQuery<T> query, String ... expectedResults) throws OperationFailedException {
        List results = this.remoteDirectory.searchGroupRelationships(query);
        LocalGroupsTest.assertEquals((int)expectedResults.length, (int)results.size());
        HashSet<String> expectedSet = new HashSet<String>(Arrays.asList(expectedResults));
        HashSet<String> actualSet = new HashSet<String>();
        if (query.getReturnType().equals(String.class)) {
            actualSet.addAll(results);
        } else {
            for (Object result : results) {
                if (!query.getReturnType().isAssignableFrom(result.getClass())) {
                    LocalGroupsTest.fail((String)("Returned result type: " + result.getClass() + " does not match requested return type: " + query.getReturnType()));
                }
                if (Group.class.isAssignableFrom(query.getReturnType())) {
                    actualSet.add(((Group)result).getName());
                    continue;
                }
                if (User.class.isAssignableFrom(query.getReturnType())) {
                    actualSet.add(((User)result).getName());
                    continue;
                }
                LocalGroupsTest.fail((String)("Result is not of type String, User or Group: " + query.getReturnType()));
            }
        }
        LocalGroupsTest.assertEquals(expectedSet, actualSet);
    }

    public void testSearchGroupRelationshipsForUserMembersOfLocalGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LOCAL_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_USER2_NAME, LDAP_USER3_NAME);
    }

    public void testSearchGroupRelationshipsForUserNameMembersOfLocalGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LOCAL_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_USER2_NAME, LDAP_USER3_NAME);
    }

    public void testSearchGroupRelationshipsForUserMembersOfLdapGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_USER2_NAME, LDAP_USER3_NAME);
    }

    public void testSearchGroupRelationshipsForUserNameMembersOfLdapGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_USER2_NAME, LDAP_USER3_NAME);
    }

    public void testSearchGroupRelationshipsForGroupMembersOfLocalGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LOCAL_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LOCAL_GROUP_NAME);
    }

    public void testSearchGroupRelationshipsForGroupNameMembersOfLocalGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LOCAL_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LOCAL_GROUP_NAME);
    }

    public void testSearchGroupRelationshipsForGroupMembersOfLdapGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_GROUP_NAME);
    }

    public void testSearchGroupRelationshipsForGroupNameMembersOfLdapGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).childrenOf(EntityDescriptor.group()).withName(LDAP_GROUP2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_GROUP_NAME);
    }

    public void testSearchGroupRelationshipsForCombinedGroupMembershipsOfUser() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(LDAP_USER2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LOCAL_GROUP2_NAME, LDAP_GROUP2_NAME);
    }

    public void testSearchGroupRelationshipsForCombinedGroupNameMembershipsOfUser() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(LDAP_USER2_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LOCAL_GROUP2_NAME, LDAP_GROUP2_NAME);
    }

    public void testSearchGroupRelationshipsForGroupMembershipsOfLocalGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(LOCAL_GROUP_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LOCAL_GROUP2_NAME);
    }

    public void testSearchGroupRelationshipsForGroupNameMembershipsOfLocalGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(LOCAL_GROUP_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LOCAL_GROUP2_NAME);
    }

    public void testSearchGroupRelationshipsForGroupMembershipsOfLdapGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(LDAP_GROUP_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_GROUP2_NAME);
    }

    public void testSearchGroupRelationshipsForGroupNameMembershipsOfLdapGroup() throws OperationFailedException {
        MembershipQuery query = QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.group()).withName(LDAP_GROUP_NAME).returningAtMost(-1);
        this.assertSearchReturns(query, LDAP_GROUP2_NAME);
    }
}

