/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraMixedCaseGroupTest
extends JiraAcceptanceTestCase {
    protected static final String JIRA_GROUP_NAME = "jira-group";
    protected static final String JIRA_MIXEDCASE_GROUP_NAME = "jira-MixedCase-Group";
    protected static final String JIRA_MIXEDCASE_DUPLICATE_GROUP_NAME = "jira-mixedcase-group";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToJira();
    }

    public void testJiraMixedCaseGroupCrud() {
        this._testCreateJiraMixedCaseGroup();
        this._testCreateJiraMixedCaseDuplicateGroup();
        this._testAddJiraMixedCaseGroupUserMembers();
        this._testRemoveJiraMixedCaseGroupUserMembers();
        this._testJiraMixedCaseUserNoPermission();
        this._testJiraMixedCaseUserWithPermission();
        this._testDeleteJiraMixedCaseGroup();
    }

    public void _testCreateJiraMixedCaseGroup() {
        this.gotoBrowseGroups();
        this.setTextField("addName", JIRA_MIXEDCASE_GROUP_NAME);
        this.submit("add_group");
        this.assertTextNotPresent("A group or user with this name already exists.");
        this.assertTextNotPresent("Error occurred adding group : jira-MixedCase-Group");
        this.assertTextInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_GROUP_NAME, "0 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_MIXEDCASE_GROUP_NAME, new String[0]);
    }

    public void _testCreateJiraMixedCaseDuplicateGroup() {
        this.gotoBrowseGroups();
        this.setTextField("addName", JIRA_MIXEDCASE_DUPLICATE_GROUP_NAME);
        this.submit("add_group");
        this.assertTextPresent("A group or user with this name already exists.");
        this.assertTextNotInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_DUPLICATE_GROUP_NAME});
        this.assertTextInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_GROUP_NAME, "0 (View)"});
        this.verifyGroupDoesNotExistInCrowd(JIRA_MIXEDCASE_DUPLICATE_GROUP_NAME);
    }

    private void _testAddJiraMixedCaseGroupUserMembers() {
        this.gotoBrowseGroups();
        this.clickLink("edit_members_of_jira-MixedCase-Group");
        this.assertTextPresent("No users in selected group(s)");
        this.setWorkingForm("jiraform");
        this.setTextField("usersToAssignStr", "jira-admin,admin");
        this.submit("assign");
        this.gotoBrowseGroups();
        this.assertTextInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_GROUP_NAME, "2 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_MIXEDCASE_GROUP_NAME, "jira-admin", "admin");
    }

    private void _testRemoveJiraMixedCaseGroupUserMembers() {
        this.gotoBrowseGroups();
        this.clickLink("edit_members_of_jira-MixedCase-Group");
        this.setWorkingForm("jiraform");
        this.selectOptions("usersToUnassign", new String[]{"jira-admin", "admin"});
        this.submit("unassign");
        this.assertTextPresent("No users in selected group(s)");
        this.gotoBrowseGroups();
        this.assertTextInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_GROUP_NAME, "0 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_MIXEDCASE_GROUP_NAME, new String[0]);
    }

    private void _testJiraMixedCaseUserNoPermission() {
        this.gotoBrowseUsers();
        this.clickLink("editgroups_test");
        this.setWorkingForm("jiraform");
        this.selectOption("groupsToLeave", "jira-users");
        this.submit("leave");
        this.logoutFromJira();
        this.loginToJira("test", "password");
        this.assertTextPresent("Log In");
    }

    private void _testJiraMixedCaseUserWithPermission() {
        this.adminLoginToJira();
        this.gotoGlobalPermissions();
        this.setWorkingForm("jiraform");
        this.selectOption("permType", "JIRA Users");
        this.selectOption("groupName", JIRA_MIXEDCASE_GROUP_NAME);
        this.submit();
        this.gotoBrowseGroups();
        this.clickLink("edit_members_of_jira-MixedCase-Group");
        this.setWorkingForm("jiraform");
        this.setTextField("usersToAssignStr", "test");
        this.submit("assign");
        this.gotoBrowseGroups();
        this.assertTextInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_GROUP_NAME, "1 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_MIXEDCASE_GROUP_NAME, "test");
        this.logoutFromJira();
        this.loginToJira("test", "password");
        this.assertTextPresent("Test User");
    }

    private void _testDeleteJiraMixedCaseGroup() {
        this.adminLoginToJira();
        this.gotoBrowseGroups();
        this.clickLink("del_jira-MixedCase-Group");
        this.assertTextPresent("Delete Group: jira-MixedCase-Group");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Group Browser");
        this.assertTextNotInTable("group_browser_table", new String[]{JIRA_MIXEDCASE_GROUP_NAME});
        this.verifyGroupDoesNotExistInCrowd(JIRA_MIXEDCASE_GROUP_NAME);
    }
}

