/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;

public class JiraGroupMutationTest
extends JiraAcceptanceTestCase {
    protected static final String JIRA_GROUP_NAME = "jira-group";

    protected void setUp() throws Exception {
        super.setUp();
        this.adminLoginToJira();
    }

    public void testJiraGroupCrud() {
        this._testCreateJiraGroup();
        this._testAddJiraGroupUserMembers();
        this._testRemoveJiraGroupUserMembers();
        this._testDeleteJiraGroup();
    }

    public void _testCreateJiraGroup() {
        this.gotoBrowseGroups();
        this.setTextField("addName", JIRA_GROUP_NAME);
        this.submit("add_group");
        this.assertTextNotPresent("A group or user with this name already exists.");
        this.assertTextInTable("group_browser_table", new String[]{JIRA_GROUP_NAME, "0 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_GROUP_NAME, new String[0]);
    }

    private void _testAddJiraGroupUserMembers() {
        this.gotoBrowseGroups();
        this.clickLink("edit_members_of_jira-group");
        this.assertTextPresent("No users in selected group(s)");
        this.setWorkingForm("jiraform");
        this.setTextField("usersToAssignStr", "jira-admin,admin");
        this.submit("assign");
        this.gotoBrowseGroups();
        this.assertTextInTable("group_browser_table", new String[]{JIRA_GROUP_NAME, "2 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_GROUP_NAME, "jira-admin", "admin");
    }

    private void _testRemoveJiraGroupUserMembers() {
        this.gotoBrowseGroups();
        this.clickLink("edit_members_of_jira-group");
        this.setWorkingForm("jiraform");
        this.selectOptions("usersToUnassign", new String[]{"jira-admin", "admin"});
        this.submit("unassign");
        this.assertTextPresent("No users in selected group(s)");
        this.gotoBrowseGroups();
        this.assertTextInTable("group_browser_table", new String[]{JIRA_GROUP_NAME, "0 (View)"});
        this.verifyGroupExistsInCrowd(JIRA_GROUP_NAME, new String[0]);
    }

    private void _testDeleteJiraGroup() {
        this.gotoBrowseGroups();
        this.clickLink("del_jira-group");
        this.assertTextPresent("Delete Group: jira-group");
        this.setWorkingForm("jiraform");
        this.submit();
        this.assertTextPresent("Group Browser");
        this.assertTextNotInTable("group_browser_table", new String[]{JIRA_GROUP_NAME});
        this.verifyGroupDoesNotExistInCrowd(JIRA_GROUP_NAME);
    }
}

