/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd.user;

import com.atlassian.crowd.acceptance.tests.applications.crowd.user.CrowdUserConsoleAcceptenceTestCase;

public class ViewApplicationsTest
extends CrowdUserConsoleAcceptenceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.loadXmlOnSetUp("userconsoletest.xml");
    }

    public void testViewApplicationsForAdmin() {
        this.log("Running testViewApplicationsForAdmin");
        this._loginAdminUser();
        this.gotoPage("/console/user/viewapplications.action");
        this.assertKeyPresent("menu.user.console.viewapplications.label");
        this.assertKeyPresent("user.console.applications.text");
        this.assertTextPresent("crowd");
        this.assertTextPresent("crowd-openid-server");
        this.assertTextPresent("demo");
    }

    public void testViewApplicationsForUser() {
        this.log("Running testViewApplicationsForUser");
        this._loginImmutableUser();
        this.gotoPage("/console/user/viewapplications.action");
        this.assertKeyPresent("menu.user.console.viewapplications.label");
        this.assertKeyPresent("user.console.applications.text");
        this.assertTextPresent("crowd");
        this.assertTextNotPresent("crowd-openid-server");
        this.assertTextNotPresent("demo");
    }

    public void testViewApplicationsForUserWithAliases() {
        this.log("Running testViewApplicationsForUserWithAliases");
        this.restoreCrowdFromXML("aliastest.xml");
        this.gotoPage("/console/user/viewapplications.action");
        this.assertKeyPresent("menu.user.console.viewapplications.label");
        this.assertKeyPresent("user.console.applications.text");
        this.assertTextInTable("applicationsTable", new String[]{"crowd", "Crowd Console", "(none)"});
        this.assertTextInTable("applicationsTable", new String[]{"demo", "Crowd Demo Application", "bob"});
        this.assertTextInTable("applicationsTable", new String[]{"crowd-openid-server", "CrowdID OpenID Provider", "(none)"});
    }
}

