/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.confluence;

import com.atlassian.crowd.acceptance.tests.applications.confluence.ConfluenceAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;
import net.sourceforge.jwebunit.api.IElement;

public class SetupConfluenceFromBackupTest
extends ConfluenceAcceptanceTestCase {
    public void testSetup() throws Exception {
        this.restoreCrowdFromXMLNoSync("crowdwithconfluencebackup.xml");
        this._setupLicense();
        this._setupDatabase();
        this._setupLoadContent();
        this._setupRestoreData();
        this._setupRestoreProgress();
        this._setupWaitForSync();
    }

    private void _setupLicense() {
        this.beginAt("/");
        this.assertTitleEquals("Confluence Setup Wizard - Confluence");
        this.assertTextPresent("Enter License");
        this.setWorkingForm("licenseform");
        this.setTextField("licenseString", "AAABKQ0ODAoPeNptkF1LwzAUhu/zKwJedzSTigwCbmkvqu02bAUVb47ZqUbSZCTpdP/e7KOg4vV53\n/d5OBe1NfQWDGWMTi9n2dUszahoWjpNWUpy9NKpbVDWcGFNpwc0El9mVNi+RycVaNqg26EjwiEcc\njkE5IdykrKEMRJrAWRYQo/8Y/BBmRsIGrxXYCbS9kTG3UlMqB3y4AYcG0UNSv9fKXaghyONd6A9n\njYqJdF4bPdbPNLEqq6Le1HOKxKnTEADUb742iq3P1tmo+VxYDn0r+hWndARim5pN+h5SlbuDYzyJ\n958FKGN7cInOKTNPqZ7T06PKHO+WLDrZF0+tsnTXdlGwnNFznLxWpX5b9yDR+d5wsbMD8PBaNWrg\nBuyHpx8B49/3/sNy3SZHDAsAhQlpKvZ3mUX4sy/D7R6HBpzP5aIZAIUAuzbc7J+FY/5QWYgnPGJx\nmL1FFM=X02eu");
        this.submit("setupTypeCustom");
    }

    private void _setupDatabase() {
        this.assertTextPresent("Choose a Database Configuration");
        this.submit("embedded");
    }

    private void _setupLoadContent() {
        this.assertTextPresent("Load Content");
        this.setWorkingForm("restoreChoiceForm");
        this.submit("dbchoiceSelect");
    }

    private void _setupRestoreData() throws Exception {
        this.assertTextPresent("Restore Data");
        this.setWorkingForm("uploadexportform");
        this.setTextField("file", AcceptanceTestHelper.getResource("confluence/xmlexport-3.5.zip").getAbsolutePath());
        IElement form = this.tester.getElementByXPath("//form[@name='uploadexportform']");
        form.setAttribute("action", form.getAttribute("action").replace("synchronous=false", "synchronous=true"));
        this.submit();
    }

    private void _setupRestoreProgress() throws Exception {
        this.assertTextPresent("Setup Restore Progress");
        this.submit();
    }

    private void _setupWaitForSync() throws InterruptedException {
        this.adminLoginToConfluence();
        this.synchroniseConfluenceWithCrowd();
    }
}

