/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.bamboo;

import com.atlassian.crowd.acceptance.tests.ApplicationAcceptanceTestCase;

public class BambooAcceptanceTestCase
extends ApplicationAcceptanceTestCase {
    protected static final String BAMBOO_ADMIN_USERNAME = "bamboo-admin-user";
    protected static final String BAMBOO_ADMIN_PASSWORD = "password";
    protected static final String BAMBOO_ADMIN_FIRSTNAME = "Bamboo";
    protected static final String BAMBOO_ADMIN_LASTNAME = "Administrator";
    protected static final String BAMBOO_ADMIN_FULL_NAME = "Bamboo Administrator";
    protected static final String BAMBOO_ADMIN_EMAIL = "bambooadmin@example.com";
    protected static final String BAMBOO_ADMINISTRATORS_GROUP = "bamboo-admin";
    protected static final String BAMBOO_USERS_GROUP = "bamboo-users";
    protected static final String UNLIMITED_LICENSE_KEY = "QONmvUrfDmCQVPgjriJkvAnJoMmCNoXgwTKkikTeEaRimkS\nmj2Kvx2S7BG9NQlaN1RkcZbB2L0LhczvdiOmzsV9HL9Cvxy\nrNnxWnnrQMpPRqOPnmwTPQOrqoQMOoMpRSUwvxtVWvuTqvp\nUUormuvppsmmmmmUUormuvppsmmmmmUU1qiXppfXk";
    protected static final String BAMBOO_MIXEDCASE_USERNAME = "MixedCaseUser";
    protected static final String BAMBOO_MIXEDCASE_PASSWORD = "password";
    protected static final String BAMBOO_MIXEDCASE_EMAIL = "mixedCase@example.com";
    private static final String BAMBOO_MIXEDCASE_FIRSTNAME = "Mixed";
    private static final String BAMBOO_MIXEDCASE_LASTNAME = "Case";
    protected static final String BAMBOO_MIXEDCASE_FULLNAME = "Mixed Case";
    protected static final String BAMBOO_MIXEDCASE_GROUP = "bamboo-MixedCase-group";

    protected String getResourceBundleName() {
        return null;
    }

    protected String getApplicationName() {
        return "bamboo";
    }

    protected String getLocalTestPropertiesFileName() {
        return "localtest.properties";
    }

    protected void gotoBrowseUsers() {
        this.gotoPage("/admin/user/viewUsers.action");
    }

    protected void gotoBrowseGroups() {
        this.gotoPage("/admin/group/viewGroups.action");
    }

    protected String loginToBamboo(String username, String password) {
        this.logoutFromBamboo();
        this.gotoPage("/userlogin.action");
        this.assertTextPresent("Log in to Bamboo");
        this.setWorkingForm("loginForm");
        this.setTextField("os_username", username);
        this.setTextField("os_password", password);
        this.submit();
        try {
            this.assertTextNotPresent("Login");
            return this.getElementTextByXPath("//li[@id='userInfo']/strong/a");
        }
        catch (AssertionError e) {
            return null;
        }
    }

    protected void logoutFromBamboo() {
        this.gotoPage("userLogout.action");
        this.assertTextPresent("First, log in or sign up");
    }

    protected void adminLoginToBamboo() {
        this.loginToBamboo(BAMBOO_ADMIN_USERNAME, "password");
        this.assertTextPresent(BAMBOO_ADMIN_FULL_NAME);
    }

    protected String getCurrentlyLoggedInBambooUserFullName() {
        this.gotoPage("/");
        try {
            this.assertTextNotPresent("Login");
            return this.getElementTextByXPath("//li[@id='userInfo']/strong/a");
        }
        catch (AssertionError e) {
            return null;
        }
    }
}

