/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.persistence;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.crowd.util.persistence.hibernate.ResetableHiLoGeneratorHelper;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.operation.DatabaseOperation;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public abstract class BaseSpringTestCase
extends AbstractTransactionalDataSourceSpringContextTests {
    private ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper;

    protected String[] getConfigLocations() {
        this.setAutowireMode(2);
        return new String[]{"classpath:/applicationContext-config.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-CrowdEncryption.xml"};
    }

    protected void onSetUp() throws Exception {
        super.onSetUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        SpringContainerContext springContainerContext = new SpringContainerContext();
        springContainerContext.setApplicationContext((ApplicationContext)this.applicationContext);
        ContainerManager.getInstance().setContainerContext((ContainerContext)springContainerContext);
        if (this.getSampleDataFileName() != null) {
            DataSource ds = this.jdbcTemplate.getDataSource();
            Connection con = DataSourceUtils.getConnection((DataSource)ds);
            DatabaseConnection dbUnitCon = new DatabaseConnection(con);
            DatabaseConfig config = dbUnitCon.getConfig();
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new HsqldbDataTypeFactory());
            InputStream datasetStream = ClassLoaderUtils.getResourceAsStream((String)this.getSampleDataFileName(), BaseSpringTestCase.class);
            FlatXmlDataSet dataSet = new FlatXmlDataSet(datasetStream);
            try {
                DatabaseOperation.CLEAN_INSERT.execute((IDatabaseConnection)dbUnitCon, (IDataSet)dataSet);
            }
            finally {
                DataSourceUtils.releaseConnection((Connection)con, (DataSource)ds);
            }
            ArrayList errors = new ArrayList();
            this.resetableHiLoGeneratorHelper.setNextHiValue(errors);
            Assert.assertTrue((boolean)errors.isEmpty());
        }
    }

    protected void flush() {
        SessionFactory sessionFactory = (SessionFactory)this.applicationContext.getBean("sessionFactory");
        Session session = sessionFactory.getCurrentSession();
        session.flush();
        session.clear();
    }

    public void setResetableHiLoGeneratorHelper(ResetableHiLoGeneratorHelper resetableHiLoGeneratorHelper) {
        this.resetableHiLoGeneratorHelper = resetableHiLoGeneratorHelper;
    }

    public abstract String getSampleDataFileName();
}

