/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.BaseTest;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.List;

public class PageAndRangeTest
extends BaseTest {
    private final String USERNAME_PREFIX = "page-user-";
    private final String GROUPNAME_PREFIX = "page-group-";
    private final String LARGE_GROUP_NAME = "PageAndRange-LargeGroup";
    private final int NUM_USERS = 2500;
    private final int NUM_GROUPS = 2500;

    protected String buildUserName(int i) {
        return "page-user-" + i;
    }

    protected String buildGroupName(int i) {
        return "page-group-" + i;
    }

    protected void removeUser(int i) {
        this.removeUser(this.buildUserName(i));
    }

    protected void addUser(int i) throws InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException {
        this.addUser(this.buildUserName(i), this.directory.getId(), "secret-password");
    }

    protected void removeGroup(int i) {
        this.removeGroup(this.buildGroupName(i));
    }

    protected void addGroup(int i) throws Exception {
        this.addGroup(this.buildGroupName(i), this.directory.getId());
    }

    protected void addUserToGroup(int userIndex, String groupName) throws Exception {
        this.getRemoteDirectory().addUserToGroup(this.buildUserName(userIndex), groupName);
    }

    protected void removeTestData() {
        int i;
        try {
            if (this.getRemoteDirectory().findUserByName(this.buildUserName(0)) != null) {
                for (i = 0; i < 2500; ++i) {
                    this.removeUser(i);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.getRemoteDirectory().findGroupByName(this.buildGroupName(0)) != null) {
                for (i = 0; i < 2500; ++i) {
                    this.removeGroup(i);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeGroup("PageAndRange-LargeGroup");
    }

    protected void loadTestData() {
    }

    public void testLargeUserSearchResult() throws Exception {
        this.logger.info((Object)">> Running testLargeUserSearchResult");
        int numExistingUsers = 0;
        List users = this.getRemoteDirectory().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        if (users != null) {
            numExistingUsers = users.size();
        }
        this.logger.info((Object)"Creating 2500 users");
        for (int i = 0; i < 2500; ++i) {
            this.addUser(i);
        }
        users = this.getRemoteDirectory().searchUsers(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        PageAndRangeTest.assertNotNull((Object)users);
        PageAndRangeTest.assertEquals((String)"Did not return all users added", (int)(numExistingUsers + 2500), (int)users.size());
        for (String user : users) {
            PageAndRangeTest.assertNotNull((Object)user);
        }
    }

    public void testLargeGroupSearchResult() throws Exception {
        this.logger.info((Object)">> Running testLargeGroupSearchResult");
        int numExistingGroups = 0;
        List groups = this.getRemoteDirectory().searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        if (groups != null) {
            numExistingGroups = groups.size();
        }
        this.logger.info((Object)"Creating 2500 groups");
        for (int i = 0; i < 2500; ++i) {
            this.addGroup(i);
        }
        groups = this.getRemoteDirectory().searchGroups(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
        PageAndRangeTest.assertNotNull((Object)groups);
        PageAndRangeTest.assertEquals((String)"Did not return all groups added", (int)(numExistingGroups + 2500), (int)groups.size());
        for (String group : groups) {
            PageAndRangeTest.assertNotNull((Object)group);
        }
    }

    public void testLargeGroupMemberSearchResult() throws Exception {
        this.logger.info((Object)">> Running testLargeGroupMemberSearchResult");
        this.addGroup("PageAndRange-LargeGroup", this.directory.getId());
        this.logger.info((Object)"Creating 2500 users, and adding each to group <PageAndRange-LargeGroup>");
        for (int i = 0; i < 2500; ++i) {
            this.addUser(i);
            this.addUserToGroup(i, "PageAndRange-LargeGroup");
        }
        List users = this.getRemoteDirectory().searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)GroupType.GROUP)).withName("PageAndRange-LargeGroup").returningAtMost(-1));
        PageAndRangeTest.assertNotNull((Object)users);
        PageAndRangeTest.assertEquals((String)"PageAndRange-LargeGroup should have 2500 members", (int)2500, (int)users.size());
        for (String user : users) {
            PageAndRangeTest.assertNotNull((Object)user);
        }
    }
}

