/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.directory;

import com.atlassian.crowd.acceptance.tests.directory.MockDirectoryManager;
import com.atlassian.crowd.acceptance.utils.DirectoryTestHelper;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.util.LDAPPropertiesHelperImpl;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.exception.DirectoryInstantiationException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserAlreadyExistsException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.InternalEntityTemplate;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserTemplateWithAttributes;
import com.atlassian.crowd.password.encoder.AtlassianSHA1PasswordEncoder;
import com.atlassian.crowd.password.encoder.LdapSshaPasswordEncoder;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.encoder.PlaintextPasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.spring.container.ContainerContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.spring.container.SpringContainerContext;
import com.google.common.collect.Sets;
import java.util.Properties;
import java.util.Set;
import org.hibernate.SessionFactory;
import org.jmock.Mock;
import org.jmock.core.Stub;
import org.jmock.core.stub.ReturnStub;
import org.quartz.Scheduler;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.AbstractTransactionalDataSourceSpringContextTests;

public abstract class BaseTest
extends AbstractTransactionalDataSourceSpringContextTests {
    protected DirectoryImpl directory;
    protected MockDirectoryManager directoryManager;
    private LDAPPropertiesHelperImpl ldapPropertiesHelperImpl;
    protected SessionFactory sessionFactory;
    private Mock mockPropertyManager;
    private String directoryConfigFile;

    protected BaseTest() {
    }

    protected BaseTest(String name) {
        super(name);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        beanFactory.registerSingleton("scheduler", new Mock(Scheduler.class).proxy());
    }

    protected String[] getConfigLocations() {
        return new String[]{"classpath:/remoteDirectoryApplicationContext-config.xml", "classpath:/applicationContext-CrowdEncryption.xml", "classpath:/applicationContext-CrowdUtils.xml", "classpath:/applicationContext-CrowdDAO.xml", "classpath:/applicationContext-config.xml"};
    }

    private String getEncryptionType(Properties directorySettings) {
        return directorySettings.getProperty("test.directory.encryption");
    }

    private void mockUpPropertyManager(String encryptionType) {
        if (encryptionType != null && encryptionType.equals("ssha")) {
            this.mockPropertyManager = new Mock(PropertyManager.class);
            this.mockPropertyManager.stubs().method("getTokenSeed").will((Stub)new ReturnStub((Object)"22EQXWJW"));
            PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
            LdapSshaPasswordEncoder passwordEncoder = (LdapSshaPasswordEncoder)passwordEncoderFactory.getLdapEncoder(encryptionType);
            passwordEncoder.setPropertyManager((PropertyManager)this.mockPropertyManager.proxy());
        }
    }

    private void addPlainTextPasswordEncoder() {
        PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
        passwordEncoderFactory.addEncoder((PasswordEncoder)new PlaintextPasswordEncoder());
    }

    private void addAtlassianSha1PasswordEncoder() {
        PasswordEncoderFactory passwordEncoderFactory = (PasswordEncoderFactory)ContainerManager.getComponent((String)"passwordEncoderFactory");
        passwordEncoderFactory.addEncoder((PasswordEncoder)new AtlassianSHA1PasswordEncoder());
    }

    private void setDirectoryInDirectoryManager(DirectoryImpl dir) {
        this.directoryManager = (MockDirectoryManager)((Object)ContainerManager.getComponent((String)"directoryManager"));
        this.directoryManager.setDirectory((Directory)dir);
    }

    protected void configureDirectory(Properties directorySettings) {
        if (this.directory == null) {
            String rolesDisabled;
            String pagedResultsSize;
            InternalEntityTemplate template = new InternalEntityTemplate();
            template.setId(null);
            template.setName("Floating Directory");
            DirectoryImpl directoryTemplate = new DirectoryImpl(template);
            directoryTemplate.setActive(true);
            directoryTemplate.setDescription("");
            directoryTemplate.setName(BaseTest.class.getName());
            directoryTemplate.setType(DirectoryType.CONNECTOR);
            String className = directorySettings.getProperty("test.directory.classname");
            directoryTemplate.setImplementationClass(className);
            directoryTemplate.setAttribute("ldap.url", directorySettings.getProperty("test.directory.url"));
            directoryTemplate.setAttribute("ldap.secure", directorySettings.getProperty("test.directory.secure"));
            directoryTemplate.setAttribute("ldap.referral", directorySettings.getProperty("test.directory.referral"));
            directoryTemplate.setAttribute("ldap.pagedresults", directorySettings.getProperty("test.directory.pagedresults.use"));
            String pooling = directorySettings.getProperty("test.directory.connectionpooling");
            if (pooling != null) {
                directoryTemplate.setAttribute("ldap.pooling", pooling);
            }
            if ((pagedResultsSize = directorySettings.getProperty("test.directory.pagedresults.size")) == null) {
                pagedResultsSize = new Integer(999).toString();
            }
            directoryTemplate.setAttribute("ldap.pagedresults.size", pagedResultsSize);
            directoryTemplate.setAttribute("ldap.basedn", directorySettings.getProperty("test.directory.basedn"));
            directoryTemplate.setAttribute("ldap.userdn", directorySettings.getProperty("test.directory.userdn"));
            directoryTemplate.setAttribute("ldap.password", directorySettings.getProperty("test.directory.password"));
            directoryTemplate.setAttribute("ldap.nestedgroups.disabled", directorySettings.getProperty("test.directory.nested.groups.disabled"));
            String encryption = this.getEncryptionType(directorySettings);
            if (encryption != null) {
                directoryTemplate.setAttribute("ldap.user.encryption", encryption);
            }
            if ((rolesDisabled = directorySettings.getProperty("ldap.roles.disabled")) != null) {
                directoryTemplate.setAttribute("ldap.roles.disabled", rolesDisabled);
            }
            Properties directorySchema = (Properties)this.ldapPropertiesHelperImpl.getConfigurationDetails().get(className);
            directoryTemplate.setAttribute("ldap.group.description", (String)directorySchema.get("ldap.group.description"));
            directoryTemplate.setAttribute("ldap.group.name", (String)directorySchema.get("ldap.group.name"));
            directoryTemplate.setAttribute("ldap.group.objectclass", (String)directorySchema.get("ldap.group.objectclass"));
            directoryTemplate.setAttribute("ldap.group.filter", (String)directorySchema.get("ldap.group.filter"));
            directoryTemplate.setAttribute("ldap.group.usernames", (String)directorySchema.get("ldap.group.usernames"));
            directoryTemplate.setAttribute("ldap.role.description", (String)directorySchema.get("ldap.role.description"));
            directoryTemplate.setAttribute("ldap.role.name", (String)directorySchema.get("ldap.role.name"));
            directoryTemplate.setAttribute("ldap.role.objectclass", (String)directorySchema.get("ldap.role.objectclass"));
            directoryTemplate.setAttribute("ldap.role.filter", (String)directorySchema.get("ldap.role.filter"));
            directoryTemplate.setAttribute("ldap.role.usernames", (String)directorySchema.get("ldap.role.usernames"));
            directoryTemplate.setAttribute("ldap.user.email", (String)directorySchema.get("ldap.user.email"));
            directoryTemplate.setAttribute("ldap.user.firstname", (String)directorySchema.get("ldap.user.firstname"));
            directoryTemplate.setAttribute("ldap.user.group", (String)directorySchema.get("ldap.user.group"));
            directoryTemplate.setAttribute("ldap.user.lastname", (String)directorySchema.get("ldap.user.lastname"));
            directoryTemplate.setAttribute("ldap.user.displayname", (String)directorySchema.get("ldap.user.displayname"));
            directoryTemplate.setAttribute("ldap.user.objectclass", (String)directorySchema.get("ldap.user.objectclass"));
            directoryTemplate.setAttribute("ldap.user.filter", (String)directorySchema.get("ldap.user.filter"));
            directoryTemplate.setAttribute("ldap.user.username", (String)directorySchema.get("ldap.user.username"));
            directoryTemplate.setAttribute("ldap.user.username.rdn", (String)directorySchema.get("ldap.user.username.rdn"));
            directoryTemplate.setAttribute("ldap.user.password", (String)directorySchema.get("ldap.user.password"));
            directoryTemplate.setAllowedOperations((Set)Sets.newHashSet((Object[])new OperationType[]{OperationType.CREATE_GROUP, OperationType.CREATE_USER, OperationType.CREATE_ROLE, OperationType.UPDATE_GROUP, OperationType.UPDATE_USER, OperationType.UPDATE_ROLE, OperationType.DELETE_GROUP, OperationType.DELETE_USER, OperationType.DELETE_ROLE}));
            DirectoryDao directoryDao = (DirectoryDao)ContainerManager.getComponent((String)"directoryDao");
            this.directory = new DirectoryImpl(directoryDao.add((Directory)directoryTemplate));
            this.sessionFactory.getCurrentSession().flush();
            template.setId(this.directory.getId());
            DirectoryImpl templateForMockDirectoryManager = new DirectoryImpl(template);
            templateForMockDirectoryManager.updateDetailsFrom((Directory)this.directory);
            this.setDirectoryInDirectoryManager(templateForMockDirectoryManager);
        }
    }

    public void setupSpring() {
        SpringContainerContext springContainerContext = new SpringContainerContext();
        springContainerContext.setApplicationContext((ApplicationContext)this.applicationContext);
        ContainerManager.getInstance().setContainerContext((ContainerContext)springContainerContext);
    }

    protected void onSetUpBeforeTransaction() throws Exception {
        super.onSetUpBeforeTransaction();
        this.setupSpring();
        this.addPlainTextPasswordEncoder();
        this.addAtlassianSha1PasswordEncoder();
    }

    protected void onSetUpInTransaction() throws Exception {
        super.onSetUpInTransaction();
        if (this.getDirectoryConfigFile() == null) {
            this.setDirectoryConfigFile(System.getProperty("directory.config.file"));
        }
        this.logger.info((Object)("Attempting to load " + this.getDirectoryConfigFile()));
        Properties properties = DirectoryTestHelper.getConfigProperties(this.getDirectoryConfigFile());
        this.mockUpPropertyManager(this.getEncryptionType(properties));
        this.configureDirectory(properties);
        this.directory.getRawImplementation().testConnection();
        this.removeTestData();
        this.loadTestData();
    }

    public void onTearDown() throws Exception {
        this.removeTestData();
        super.onTearDown();
    }

    protected abstract void removeTestData();

    protected abstract void loadTestData() throws Exception;

    public void setLdapPropertiesHelper(LDAPPropertiesHelperImpl ldapPropertiesHelperImpl) {
        this.ldapPropertiesHelperImpl = ldapPropertiesHelperImpl;
    }

    public void setDirectoryConfigFile(String directoryConfigFile) {
        this.directoryConfigFile = directoryConfigFile;
    }

    public String getDirectoryConfigFile() {
        return this.directoryConfigFile;
    }

    protected RemoteDirectory getRemoteDirectory() throws DirectoryInstantiationException {
        RemoteDirectory remoteDirectory = this.directory.getImplementation();
        return remoteDirectory;
    }

    protected void removeUser(String userName) {
        try {
            this.getRemoteDirectory().removeUser(userName);
        }
        catch (UserNotFoundException e) {
            this.logger.debug((Object)e);
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
    }

    protected void removeGroup(String groupName) {
        try {
            this.getRemoteDirectory().removeGroup(groupName);
        }
        catch (GroupNotFoundException e) {
            this.logger.debug((Object)e);
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
    }

    protected void removeRole(String roleName) {
        try {
            this.getRemoteDirectory().removeGroup(roleName);
        }
        catch (GroupNotFoundException e) {
            this.logger.debug((Object)e);
        }
        catch (Exception e) {
            this.logger.warn((Object)e);
        }
    }

    protected UserTemplateWithAttributes buildUser(String userName, Long directoryId) {
        return this.buildUser(userName, "test@example.com", "Test", "User", directoryId);
    }

    protected UserTemplateWithAttributes buildUser(String userName, String emailAddress, String firstName, String lastName, Long directoryId) {
        UserTemplateWithAttributes user = new UserTemplateWithAttributes(userName, directoryId.longValue());
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setEmailAddress(emailAddress);
        user.setDisplayName(firstName + " " + lastName);
        user.setActive(true);
        return user;
    }

    protected void addUser(UserTemplate user, String password) throws InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException {
        user.setDirectoryId(this.getRemoteDirectory().getDirectoryId());
        this.getRemoteDirectory().addUser(user, new PasswordCredential(password));
    }

    protected void addUser(String userName, Long directoryId, String password) throws InvalidCredentialException, InvalidUserException, OperationFailedException, UserAlreadyExistsException, DirectoryNotFoundException, UserNotFoundException {
        this.getRemoteDirectory().addUser((UserTemplate)this.buildUser(userName, directoryId), new PasswordCredential(password));
    }

    protected GroupTemplate buildGroup(String groupName, Long directoryId) {
        GroupTemplate group = new GroupTemplate(groupName, directoryId.longValue(), GroupType.GROUP);
        group.setActive(true);
        return group;
    }

    protected Group addGroup(String groupName, Long directoryId) throws InvalidGroupException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        GroupTemplate groupTemplate = this.buildGroup(groupName, directoryId);
        Group addedGroup = this.getRemoteDirectory().addGroup(groupTemplate);
        BaseTest.assertEquals((Object)groupTemplate, (Object)new GroupTemplate(addedGroup));
        return addedGroup;
    }

    protected void addGroup(GroupTemplate group) throws InvalidCredentialException, InvalidUserException, InvalidGroupException, OperationFailedException, DirectoryNotFoundException, GroupNotFoundException {
        group.setDirectoryId(this.getRemoteDirectory().getDirectoryId());
        this.getRemoteDirectory().addGroup(group);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

