/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.jira;

import com.atlassian.crowd.acceptance.tests.applications.jira.JiraAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;

public class SetupJiraTest
extends JiraAcceptanceTestCase {
    public void testSetup() {
        this.restoreCrowdFromXMLNoSync("crowdwithjira.xml");
        this._setupFromBackup();
        this.waitForInitialSync();
        this.verifyDashboardOk();
        this._setupTestUser();
    }

    private void waitForInitialSync() {
        for (int i = 0; i < 10; ++i) {
            if (this.loginToJira("jira-admin", "password") != null) {
                this.logger.info((Object)("Initial synchronisation took " + i + " seconds"));
                break;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void _setupFromBackup() {
        this.beginAt("/secure/SetupImport!default.jspa");
        this.assertTextPresent("Import Existing Data");
        this.setWorkingForm("jiraform");
        this.setTextField("filename", AcceptanceTestHelper.getResource("jira/xmlexport-4.3.zip").getAbsolutePath());
        this.submit();
        this.assertTextPresent("Setup Complete");
    }

    private void verifyDashboardOk() {
        this.setScriptingEnabled(true);
        this.gotoPage("/secure/Dashboard.jspa");
        this.setScriptingEnabled(false);
    }

    private void _setupTestUser() {
        this.adminLoginToJira();
        this.gotoBrowseUsers();
        this.clickLink("add_user");
        this.assertTextPresent("Create New User");
        this.setWorkingForm("jiraform");
        this.setTextField("username", "test");
        this.setTextField("password", "password");
        this.setTextField("confirm", "password");
        this.setTextField("fullname", "Test User");
        this.setTextField("email", "test@example.com");
        this.uncheckCheckbox("sendEmail");
        this.submit();
        this.assertTextPresent("User: Test User");
        this.assertTextPresent("test");
        this.assertTextPresent("Test User");
        this.assertTextPresent("test@example.com");
        this.assertTextPresent("jira-users");
    }
}

