/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowdid.server;

import com.atlassian.crowd.acceptance.tests.applications.crowdid.server.CrowdIDServerAcceptanceTestCase;
import com.atlassian.crowd.acceptance.utils.AcceptanceTestHelper;

public class OpenIDServerTest
extends CrowdIDServerAcceptanceTestCase {
    protected static String OPENIDSERVER_LOGIN_URL_ADMIN;
    protected static String OPENID_CLIENT_LOGIN;
    protected static String OPENID_SERVER_URL;
    protected static final String CLIENT_NAME = "crowdidclient";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.loginToCrowd();
        this.restoreCrowdFromXML("basesetup.xml");
        this.logoutFromCrowd();
        this.specProperties = AcceptanceTestHelper.loadProperties("localtest.properties");
        String client_port = this.getTestProperty("crowdidclient.port");
        String client_context = this.getTestProperty("crowdidclient.context");
        String client_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + client_port;
        String server_port = this.getTestProperty(this.getApplicationName() + ".port");
        String server_context = this.getTestProperty(this.getApplicationName() + ".context");
        String server_rootUrl = "http://" + this.getTestProperty("host.location") + ":" + server_port;
        OPENID_CLIENT_LOGIN = client_rootUrl + client_context;
        OPENID_SERVER_URL = server_rootUrl + server_context;
        OPENIDSERVER_LOGIN_URL_ADMIN = OPENID_SERVER_URL + "/users/" + "admin";
    }

    public void tearDown() throws Exception {
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testProfile() {
        this.log("Running testProfile");
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("myprofiles");
        this.assertKeyPresent("profiles.select.title");
        this.selectOptionByValue("profileID", "-1");
        this.setTextField("profileName", "");
        this.submit();
        this.assertKeyPresent("profiles.nameempty.error");
        this.setTextField("profileName", "My Profile");
        this.submit();
        this.assertKeyPresent("exception.profile.already.exists");
        this.setTextField("profileName", "Test Profile");
        this.assertTextFieldEquals("nickname", "admin");
        this.setTextField("nickname", "tester");
        this.assertTextFieldEquals("fullName", "Super User");
        this.setTextField("fullName", "Test User");
        this.assertTextFieldEquals("email", "admin@example.com");
        this.setTextField("email", "test@example.com");
        this.selectOption("dobDay", "1");
        this.selectOption("dobMonth", "April");
        this.selectOption("dobYear", "1990");
        this.submit();
        this.assertKeyPresent("profiles.updated.message");
        this.clickLink("resumeauthentication");
        this.selectOption("profileID", "Test Profile");
        this.assertTextInTable("attributeTable", new String[]{"Nickname", "tester"});
        this.assertTextInTable("attributeTable", new String[]{"Full Name", "Test User"});
        this.assertTextInTable("attributeTable", new String[]{"Email", "test@example.com"});
        this.assertTextInTable("attributeTable", new String[]{"Birth Date", "1 April 1990"});
        this.gotoPage(OPENID_SERVER_URL);
        this.clickLink("myprofiles");
        this.selectOption("profileID", "Test Profile");
        this.clickButtonWithText("Delete");
        this.assertKeyPresent("profiles.deleted.message");
    }

    public void testApprovedSites() {
        this.log("Running testApprovedSites");
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("mysites");
        this.assertKeyPresent("allow.nosites.label");
        this.clickLink("resumeauthentication");
        this.clickLink("allowAlways");
        this.gotoPage(OPENID_SERVER_URL);
        this.clickLink("mysites");
        this.assertKeyPresent("allow.siteurl.label");
        this.assertTextPresent(OPENID_CLIENT_LOGIN);
        this.clickElementByXPath("//img[@id='removeSite-0']");
        this.assertTextNotPresent(OPENID_CLIENT_LOGIN);
        this.clickButtonWithText("Apply");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertKeyPresent("allow.nosites.label");
    }

    public void testLoginHistory() {
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLink("allow");
        this.clickLinkWithExactText("Log Out");
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.clickLink("deny");
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.clickLink("allowAlways");
        this.clickLinkWithExactText("Log Out");
        this.gotoPage(OPENID_SERVER_URL);
        this.clickLink("activity");
        this.assertKeyPresent("authaction.allow.label");
        this.assertKeyPresent("authaction.deny.label");
        this.assertKeyPresent("authaction.allowalways.label");
        this.clickLink("mysites");
        this.assertKeyPresent("allow.siteurl.label");
        this.assertTextPresent(OPENID_CLIENT_LOGIN);
        this.clickElementByXPath("//img[@id='removeSite-0']");
        this.assertTextNotPresent(OPENID_CLIENT_LOGIN);
        this.clickButtonWithText("Apply");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertKeyPresent("allow.nosites.label");
    }

    public void testAdminTrustRelationships() {
        this.gotoPage(OPENID_SERVER_URL);
        this.setTextField("username", "admin");
        this.setTextField("password", "admin");
        this.submit();
        this.clickLinkWithExactText("Administration");
        this.clickLink("loginrestrictions");
        this.assertKeyPresent("trusts.label");
        this.clickRadioOption("trustType", "2");
        this.assertKeyPresent("blacklisthost.label");
        this.setTextField("address", "localhost");
        this.submit();
        this.setTextField("address", "random");
        this.submit();
        this.assertTextInTable("addressesTable", new String[]{"localhost", "Remove"});
        this.assertTextInTable("addressesTable", new String[]{"random", "Remove"});
        this.clickLink("remove-1");
        this.assertTextInTable("addressesTable", new String[]{"localhost", "Remove"});
        this.assertTextNotInTable("addressesTable", "random");
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.assertKeyPresent("allow.error.title");
        this.clickLinkWithExactText("Administration");
        this.clickLink("loginrestrictions");
        this.assertKeyPresent("trusts.label");
        this.clickRadioOption("trustType", "1");
        this.assertKeyPresent("whitelisthost.label");
        this.assertTextInTable("addressesTable", new String[]{"localhost", "Remove"});
        this.gotoPage(OPENID_CLIENT_LOGIN);
        this.setTextField("openid_identifier", OPENIDSERVER_LOGIN_URL_ADMIN);
        this.submit();
        this.assertKeyPresent("allow.auth.title");
        this.clickLinkWithExactText("Administration");
        this.clickLink("loginrestrictions");
        this.clickLink("remove-0");
        this.clickRadioOption("trustType", "0");
    }
}

