/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;

public class ViewPrincipalTest
extends CrowdAcceptanceTestCase {
    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("viewprincipaltest.xml");
    }

    public void tearDown() throws Exception {
        this.restoreBaseSetup();
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testAddRoleToPrincipal() {
        this.log("Running: testAddRoleToPrincipal");
        this.gotoViewPrincipal("justin", "Atlassian");
        this.clickLink("user-roles-tab");
        this.setWorkingForm("rolesForm");
        this.selectOption("unsubscribedRole", "crowd-users");
        this.clickButton("add-role");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertSelectOptionValuesEqual("unsubscribedRole", new String[]{"crowd-managers"});
        this.assertTextInTable("rolesTable", "crowd-users");
    }

    public void testRemoveRoleFromPrincipal() {
        this.log("Running: testRemoveRoleFromPrincipal");
        this.gotoViewPrincipal("justin", "Atlassian");
        this.setWorkingForm("rolesForm");
        this.clickLink("removerole-crowd-developers-Atlassian");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertSelectOptionValuesEqual("unsubscribedRole", new String[]{"crowd-developers", "crowd-managers", "crowd-users"});
        this.assertTextNotInTable("rolesTable", "crowd-developers");
    }

    public void testUpdateMainAttributes() {
        this.log("Running: testUpdateMainAttributes");
        this.gotoViewPrincipal("justin", "Atlassian");
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("firstname", "Billy");
        this.setTextField("lastname", "Bob");
        this.setTextField("email", "billy@atlassian.com");
        this.uncheckCheckbox("active");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextFieldEquals("firstname", "Billy");
        this.assertTextFieldEquals("lastname", "Bob");
        this.assertTextFieldEquals("email", "billy@atlassian.com");
        this.assertCheckboxNotSelected("active");
    }

    public void testAddNewPrincipalAttribute() {
        this.log("Running: testAddNewPrincipalAttribute");
        this.gotoViewPrincipal("justin", "Atlassian");
        this.clickLink("user-attributes-tab");
        this.setWorkingForm("attributesForm");
        this.setTextField("attribute", "company");
        this.setTextField("value", "Atlassian");
        this.clickButton("add-attribute");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextInTable("attributesTable", new String[]{"company", "Atlassian"});
    }

    public void testUpdatePrincipalAttributes() {
        this.log("Running: testUpdatePrincipalAttributes");
        this.gotoViewPrincipal("justin", "Atlassian");
        this.clickLink("user-attributes-tab");
        this.setWorkingForm("attributesForm");
        this.setTextField("phone1", "9999-5555");
        this.setTextField("country1", "Tibet");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextInTable("attributesTable", new String[]{"9999-5555", "Tibet"});
    }

    public void testRemovePrincipalAttribute() {
        this.log("Running: testRemovePrincipalAttribute");
        this.gotoViewPrincipal("justin", "Atlassian");
        this.setWorkingForm("attributesForm");
        this.clickLink("remove-country");
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotInTable("attributesTable", new String[]{"country", "Australia"});
    }

    public void testEditApacheDSPrincipal() {
        this.gotoViewPrincipal("jdoe", "Apache DS");
        this.setWorkingForm("updateprincipalForm");
        this.setTextField("firstname", "John");
        this.setTextField("lastname", "Small");
        this.setTextField("email", "john@test.org");
        this.submit();
        this.assertTextFieldEquals("firstname", "John");
        this.assertTextFieldEquals("lastname", "Small");
        this.assertTextFieldEquals("email", "john@test.org");
    }

    public void testRemoveUserNotPossibleEvenViaUrlHack() {
        this._loginAdminUser();
        this.gotoRemovePrincipal("admin", "Atlassian");
        this.assertFormNotPresent("remove-user-form");
        this.assertKeyPresent("principal.remove.curent.user");
    }

    public void testRemoveUserLinkNotPresentForLoggedInUser() {
        this._loginAdminUser();
        this.gotoViewPrincipal("admin", "Atlassian");
        this.assertLinkNotPresent("remove-principal");
    }

    public void testRemoveUser() {
        this.gotoViewPrincipal("justin", "Atlassian");
        this.clickLink("remove-principal");
        this.submit();
        this.assertKeyPresent("updatesuccessful.label");
        this.assertTextNotPresent("justin@atlassian.com");
    }

    public void testViewUserGroupsTabWithNoModifyGroupPermissions() {
        this.gotoBrowseDirectories();
        this.clickLinkWithExactText("Atlassian");
        this.clickLink("internal-permissions");
        this.setWorkingForm("permissionForm");
        this.uncheckCheckbox("permissionGroupModify");
        this.submit();
        this.gotoViewPrincipal("justin", "Atlassian");
        this.clickLink("user-groups-tab");
        this.assertKeyPresent("group.modify.disabled");
        this.assertButtonNotPresent("addGroups");
        this.assertButtonNotPresent("removeGroups");
        this.assertTextInTable("groupsTable", new String[]{"crowd-administrators", "", "true"});
    }

    public void testViewUserGroupsTabWithModifyGroupPermissions() {
        this.gotoViewPrincipal("justin", "Atlassian");
        this.clickLink("user-groups-tab");
        this.assertKeyNotPresent("group.modify.disabled");
        this.assertButtonPresent("addGroups");
        this.assertButtonPresent("removeGroups");
        this.assertTextInTable("groupsTable", new String[]{"crowd-administrators", "", "true"});
    }
}

