/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.acceptance.tests.applications.crowd;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.acceptance.tests.applications.crowd.CrowdAcceptanceTestCase;
import org.apache.commons.lang.StringUtils;

public class DirectoryImporterTest
extends CrowdAcceptanceTestCase {
    private static final String SOURCE_DIRECTORY_NAME = "Test Internal Directory";
    private static final String TARGET_DIRECTORY_NAME = "Blank Internal Directory";
    private static final String DIFFERENT_ENCRYPTION_DIRECTORY_NAME = "Third Directory";

    public void setUp() throws Exception {
        super.setUp();
        this.setScriptingEnabled(true);
        this.restoreCrowdFromXML("directoryimportertest.xml");
        this._loginAdminUser();
        this.gotoImporters();
        this.clickButton("importdirectory");
    }

    public void tearDown() throws Exception {
        this.restoreBaseSetup();
        this.setScriptingEnabled(false);
        super.tearDown();
    }

    public void testBothDirectoriesCannotBeTheSame() {
        this.log("Running testBothDirectoriesCannotBeTheSame");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", TARGET_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.sourcetargetsame.error");
    }

    public void testUserEncryptionMustBeTheSame() {
        this.log("Running testUserEncryptionMustBeTheSame");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", TARGET_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", DIFFERENT_ENCRYPTION_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.same.encryption.error");
    }

    public void testPerformDirectoryMigration() {
        this.log("Running testPerformDirectoryMigration");
        this.setWorkingForm("dataimport");
        this.selectOption("sourceDirectoryID", SOURCE_DIRECTORY_NAME);
        this.selectOption("targetDirectoryID", TARGET_DIRECTORY_NAME);
        this.submit();
        this.assertKeyPresent("dataimport.directory.source.confirmation.directory.text", EasyList.build((Object)SOURCE_DIRECTORY_NAME));
        this.assertKeyPresent("dataimport.directory.target.confirmation.directory.text", EasyList.build((Object)TARGET_DIRECTORY_NAME));
        this.assertKeyPresent("dataimport.directory.overwrite.confirmation.directory.text", EasyList.build((Object)StringUtils.capitalize((String)Boolean.FALSE.toString())));
        this.setWorkingForm("dataimport");
        this.submit();
        this.assertKeyPresent("dataimport.atlassianimportsuccess.text");
    }
}

