/*
 * Copyright © 2010 - 2012 Atlassian Corporation Pty Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.atlassian.crowd.model.event;

import com.atlassian.crowd.embedded.api.Directory;

import java.util.Collections;
import java.util.Set;

public class UserMembershipEvent extends AbstractOperationEvent
{
    private final String childUsername;
    private final Set<String> parentGroupNames;

    public UserMembershipEvent(Operation operation, Directory directory, String childUsername, String groupName)
    {
        super(operation, directory);
        this.childUsername = childUsername;
        this.parentGroupNames = Collections.singleton(groupName);
    }

    public UserMembershipEvent(Operation operation, Directory directory, String childUsername, Set<String> parentGroupNames)
    {
        super(operation, directory);
        this.childUsername = childUsername;
        this.parentGroupNames = parentGroupNames;
    }

    public Set<String> getParentGroupNames()
    {
        return parentGroupNames;
    }

    public String getChildUsername()
    {
        return childUsername;
    }

    @Override
    public String toString()
    {
        return "UserMembershipEvent{" +
               "operation=" + getOperation() +
               ",directory=" + getDirectory() +
               ",childUsername='" + childUsername + '\'' +
               ", parentGroupNames=" + parentGroupNames +
               '}';
    }
}
