package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.cache.CacheFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.user.configuration.*;
import com.atlassian.user.impl.cache.properties.CachingPropertySetFactory;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.RepositoryIdentifier;

/**
 * Constructs the Crowd RepositoryAccessor, ensuring that the correct implementations are cached.
 */
public final class EmbeddedCrowdRepositoryProcessor implements RepositoryProcessor
{
    @Override
    public RepositoryAccessor process(RepositoryConfiguration configuration)
    {
        RepositoryIdentifier identifier = configuration.getIdentifier();
        CrowdService crowdService = (CrowdService) configuration.getComponent("crowdService");
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService) configuration.getComponent("crowdDirectoryService");
        CacheFactory cacheFactory = (CacheFactory) configuration.getComponent(Configuration.CACHEFACTORY);

        DefaultRepositoryAccessor accessor = new DefaultRepositoryAccessor();
        accessor.setRepository(identifier);
        accessor.setAuthenticator(new EmbeddedCrowdAuthenticator(identifier, crowdService));
        accessor.setPropertySetFactory(new CachingPropertySetFactory((PropertySetFactory) configuration.getComponent("crowdPropertySetFactory"), cacheFactory));
        accessor.setEntityQueryParser(new EmbeddedCrowdEntityQueryParser(identifier, crowdService));

        EmbeddedCrowdUserManager userManager = new EmbeddedCrowdUserManager(identifier, crowdService, crowdDirectoryService);
        accessor.setUserManager(userManager);
        EmbeddedCrowdGroupManager groupManager = new EmbeddedCrowdGroupManager(identifier, crowdService);
        accessor.setGroupManager(groupManager);
        
        return accessor;
    }
}
