package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.crowd.embedded.propertyset.DebugLoggingPropertySet;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.properties.PropertySetFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.module.propertyset.hibernate.HibernateConfigurationProvider;

import java.util.HashMap;
import java.util.Map;

public class EmbeddedCrowdPropertySetFactory implements PropertySetFactory
{
    private static final String HIBERNATE_PROPERTY_SET = "hibernate";
    public static final String PROPERTY_PREFIX = "CWD_";

    private final CrowdService crowdService;
    private final HibernateConfigurationProvider configProvider;

    public EmbeddedCrowdPropertySetFactory(CrowdService crowdService, HibernateConfigurationProvider configProvider)
    {
        this.crowdService = crowdService;
        this.configProvider = configProvider;
    }

    @Override
    public PropertySet getPropertySet(Entity entity) throws EntityException
    {
        if (!(entity instanceof User))
            throw new UnsupportedOperationException("This implementation only supports user properties");

        UserWithAttributes user = crowdService.getUserWithAttributes(entity.getName());
        if (user == null)
            return null; // user does not exist

        Map<String, Object> args = new HashMap<String, Object>();

        args.put("entityId", 0L);
        args.put("entityName", PROPERTY_PREFIX + user.getName());
        args.put("configurationProvider", configProvider);

        return new DebugLoggingPropertySet(PropertySetManager.getInstance(HIBERNATE_PROPERTY_SET, args));
    }
}
