package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.crowd.embedded.api.Group;

public class EmbeddedCrowdGroup implements com.atlassian.user.Group, Group
{
    private final String name;

    EmbeddedCrowdGroup(Group crowdGroup)
    {
        this.name = crowdGroup.getName();
    }

    @Override
    public String getName()
    {
        return name;
    }

    @Override
    public int compareTo(Group group)
    {
        return name.compareToIgnoreCase(group.getName());
    }

    @Override
    public String toString()
    {
        return name;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EmbeddedCrowdGroup that = (EmbeddedCrowdGroup) o;

        if (name != null ? !name.equals(that.name) : that.name != null) return false;

        return true;
    }

    @Override
    public int hashCode()
    {
        return name != null ? name.hashCode() : 0;
    }
}
