package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.runtime.UserNotFoundException;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EmbeddedCrowdAuthenticator implements Authenticator
{
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCrowdAuthenticator.class);
    private final RepositoryIdentifier repositoryIdentifier;
    private final CrowdService crowdService;

    public EmbeddedCrowdAuthenticator(final RepositoryIdentifier repositoryIdentifier, final CrowdService crowdService)
    {
        this.repositoryIdentifier = repositoryIdentifier;
        this.crowdService = crowdService;
    }

    @Override
    public boolean authenticate(final String username, final String password)
    {
        log.debug("Authenticating user '{}' by password", username);
        try
        {
            boolean result = crowdService.authenticate(username, password) != null;
            assert result : "Result must always be true if an exception was not thrown";
            log.debug("Authentication successful for user '{}'", username);
            return result;
        }
        catch (UserNotFoundException e)
        {
            log.debug("Authentication failed for username '{}' because user could not be found.", username);
            return false;
        }
        catch (InactiveAccountException e)
        {
            log.debug("Authentication failed for username '{}' because user is inactive.", username);
            return false;
        }
        catch (ExpiredCredentialException e)
        {
            log.debug("Authentication failed for username '{}' because the credentials have expired.", username);
            return false;
        }
        catch (FailedAuthenticationException e)
        {
            log.debug("Authentication failed for username '{}' because the password was incorrect.", username);
            return false;
        }
    }

    @Override
    public RepositoryIdentifier getRepository()
    {
        return repositoryIdentifier;
    }
}
