package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.SearchResult;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.Pagers;
import com.google.common.collect.Iterables;

import java.util.Collections;
import java.util.Set;

/**
 * Search results returned by the Crowd Atlassian-User API.
 *
 * @param <T> the type of the search result, which must be either {@link User} or {@link Group}
 */
// TODO: load results on-demand from the underlying Crowd search results object
final class CrowdSearchResult<T> implements SearchResult<T>
{
    private final RepositoryIdentifier repositoryIdentifier;
    private final DefaultPager<T> results;

    static CrowdSearchResult<Group> forGroups(RepositoryIdentifier repositoryIdentifier, Iterable<com.atlassian.crowd.embedded.api.Group> results)
    {
        return new CrowdSearchResult<Group>(repositoryIdentifier,
            Iterables.transform(results, Conversions.TO_ATLASSIAN_GROUP));
    }

    static CrowdSearchResult<User> forUsers(RepositoryIdentifier repositoryIdentifier, Iterable<com.atlassian.crowd.embedded.api.User> results)
    {
        return new CrowdSearchResult<User>(repositoryIdentifier,
            Iterables.transform(results, Conversions.TO_ATLASSIAN_USER));
    }

    private CrowdSearchResult(RepositoryIdentifier repositoryIdentifier, Iterable<T> results)
    {
        this.repositoryIdentifier = repositoryIdentifier;
        this.results = Pagers.newDefaultPager(results);
    }

    @Override
    public Pager<T> pager()
    {
        return results;
    }

    @Override
    public Pager<T> pager(String repoKey)
    {
        if (repositoryIdentifier.getKey().equals(repoKey))
            return results;
        return null;
    }

    @Override
    public Set<String> repositoryKeyset()
    {
        return Collections.singleton(repositoryIdentifier.getKey());
    }
}
