/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.atlassianuser;

import com.atlassian.cache.CacheFactory;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdAuthenticator;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdEntityQueryParser;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdGroupManager;
import com.atlassian.crowd.embedded.atlassianuser.EmbeddedCrowdUserManager;
import com.atlassian.user.GroupManager;
import com.atlassian.user.UserManager;
import com.atlassian.user.configuration.DefaultRepositoryAccessor;
import com.atlassian.user.configuration.RepositoryAccessor;
import com.atlassian.user.configuration.RepositoryConfiguration;
import com.atlassian.user.configuration.RepositoryProcessor;
import com.atlassian.user.impl.cache.properties.CachingPropertySetFactory;
import com.atlassian.user.properties.PropertySetFactory;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.query.EntityQueryParser;
import com.atlassian.user.security.authentication.Authenticator;

public final class EmbeddedCrowdRepositoryProcessor
implements RepositoryProcessor {
    public RepositoryAccessor process(RepositoryConfiguration configuration) {
        RepositoryIdentifier identifier = configuration.getIdentifier();
        CrowdService crowdService = (CrowdService)configuration.getComponent("crowdService");
        CrowdDirectoryService crowdDirectoryService = (CrowdDirectoryService)configuration.getComponent("crowdDirectoryService");
        CacheFactory cacheFactory = (CacheFactory)configuration.getComponent("cacheFactory");
        DefaultRepositoryAccessor accessor = new DefaultRepositoryAccessor();
        accessor.setRepository(identifier);
        accessor.setAuthenticator((Authenticator)new EmbeddedCrowdAuthenticator(identifier, crowdService));
        accessor.setPropertySetFactory((PropertySetFactory)new CachingPropertySetFactory((PropertySetFactory)configuration.getComponent("crowdPropertySetFactory"), cacheFactory));
        accessor.setEntityQueryParser((EntityQueryParser)new EmbeddedCrowdEntityQueryParser(identifier, crowdService));
        EmbeddedCrowdUserManager userManager = new EmbeddedCrowdUserManager(identifier, crowdService, crowdDirectoryService);
        accessor.setUserManager((UserManager)userManager);
        EmbeddedCrowdGroupManager groupManager = new EmbeddedCrowdGroupManager(identifier, crowdService);
        accessor.setGroupManager((GroupManager)groupManager);
        return accessor;
    }
}

