/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.request.oauth2.JwtBearerAccessTokenProvider;
import com.atlassian.connect.spring.internal.request.oauth2.JwtBearerResourceDetails;
import com.atlassian.connect.spring.internal.request.oauth2.OAuth2HttpRequestInterceptor;
import com.atlassian.connect.spring.internal.request.oauth2.OAuth2JwtAssertionGenerator;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class OAuth2RestTemplateFactory {
    private static final URI STAGING_AUTHORIZATION_SERVER_URL = URI.create("https://oauth-2-authorization-server.stg.services.atlassian.com");
    private static final URI PRODUCTION_AUTHORIZATION_SERVER_URL = URI.create("https://oauth-2-authorization-server.services.atlassian.com");
    private final OAuth2JwtAssertionGenerator jwtAssertionGenerator;
    private final RestTemplateBuilder restTemplateBuilder;
    private final RestTemplate accessTokenProviderRestTemplate;
    private final String atlassianConnectClientVersion;

    @Autowired
    public OAuth2RestTemplateFactory(OAuth2JwtAssertionGenerator jwtAssertionGenerator, RestTemplateBuilder restTemplateBuilder, @Value(value="${atlassian.connect.client-version}") String atlassianConnectClientVersion) {
        this.jwtAssertionGenerator = jwtAssertionGenerator;
        this.restTemplateBuilder = restTemplateBuilder;
        this.accessTokenProviderRestTemplate = restTemplateBuilder.build();
        this.atlassianConnectClientVersion = atlassianConnectClientVersion;
    }

    @Cacheable(value={"oauth-2-clients"})
    public OAuth2RestTemplate getOAuth2RestTemplate(AtlassianHostUser hostUser) {
        this.assertValidHostUser(hostUser);
        URI authorizationServerBaseUrl = this.getAuthorizationServerBaseUrl(hostUser.getHost());
        OAuth2ProtectedResourceDetails protectedResourceDetails = this.createProtectedResourceDetails(hostUser, authorizationServerBaseUrl);
        OAuth2RestTemplate oAuth2RestTemplate = new OAuth2RestTemplate(protectedResourceDetails);
        this.restTemplateBuilder.configure((RestTemplate)oAuth2RestTemplate);
        oAuth2RestTemplate.setAccessTokenProvider((AccessTokenProvider)this.createAccessTokenProvider(hostUser, authorizationServerBaseUrl));
        oAuth2RestTemplate.getInterceptors().add(this.createRequestInterceptor(hostUser));
        return oAuth2RestTemplate;
    }

    public RestTemplate getAccessTokenProviderRestTemplate() {
        return this.accessTokenProviderRestTemplate;
    }

    private void assertValidHostUser(AtlassianHostUser hostUser) {
        if (StringUtils.isEmpty((Object)hostUser.getHost().getOauthClientId())) {
            throw new IllegalArgumentException("Can not act as a user for a host with no OAuthClientId. Make sure you have ACT_AS_USER scope specified in your descriptor.");
        }
        if (!(hostUser.getUserAccountId().isPresent() || hostUser.getUserKey() != null && hostUser.getUserKey().isPresent())) {
            throw new IllegalArgumentException("The provided AtlassianHostUser did not specify a user to act as.");
        }
    }

    private URI getAuthorizationServerBaseUrl(AtlassianHost host) {
        boolean isStagingHost = URI.create(host.getBaseUrl()).getHost().endsWith(".jira-dev.com");
        return isStagingHost ? STAGING_AUTHORIZATION_SERVER_URL : PRODUCTION_AUTHORIZATION_SERVER_URL;
    }

    private OAuth2ProtectedResourceDetails createProtectedResourceDetails(AtlassianHostUser hostUser, URI authorizationServerBaseUrl) {
        return new JwtBearerResourceDetails(hostUser.getHost().getClientKey(), hostUser.getHost().getSharedSecret(), authorizationServerBaseUrl.toASCIIString());
    }

    private JwtBearerAccessTokenProvider createAccessTokenProvider(AtlassianHostUser hostUser, URI authorizationServerBaseUrl) {
        return new JwtBearerAccessTokenProvider(hostUser, authorizationServerBaseUrl, this.accessTokenProviderRestTemplate, this.jwtAssertionGenerator);
    }

    private OAuth2HttpRequestInterceptor createRequestInterceptor(AtlassianHostUser hostUser) {
        return new OAuth2HttpRequestInterceptor(hostUser.getHost(), this.atlassianConnectClientVersion);
    }
}

