/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.request.oauth2.JwtBearerResourceDetails;
import com.atlassian.connect.spring.internal.request.oauth2.OAuth2JwtAssertionGenerator;
import java.net.URI;
import java.util.Calendar;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.resource.UserApprovalRequiredException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class JwtBearerAccessTokenProvider
implements AccessTokenProvider {
    public static final ParameterizedTypeReference<Map<String, String>> ACCESS_TOKEN_RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, String>>(){};
    private static final Logger log = LoggerFactory.getLogger(JwtBearerAccessTokenProvider.class);
    private static final int CLOCK_SKEW_SECONDS = 60;
    private final RestTemplate restTemplate;
    private final AtlassianHostUser hostUser;
    private final URI authorizationServerUrl;
    private OAuth2JwtAssertionGenerator jwtAssertionGenerator;

    public JwtBearerAccessTokenProvider(AtlassianHostUser hostUser, URI authorizationServerUrl, RestTemplate restTemplate, OAuth2JwtAssertionGenerator jwtAssertionGenerator) {
        this.hostUser = hostUser;
        this.restTemplate = restTemplate;
        this.authorizationServerUrl = authorizationServerUrl;
        this.jwtAssertionGenerator = jwtAssertionGenerator;
    }

    public OAuth2AccessToken obtainAccessToken(OAuth2ProtectedResourceDetails oAuth2ProtectedResourceDetails, AccessTokenRequest accessTokenRequest) throws UserRedirectRequiredException, UserApprovalRequiredException, AccessDeniedException {
        log.debug("Requesting OAuth 2.0 access token using {}", (Object)oAuth2ProtectedResourceDetails.getGrantType());
        String assertionString = this.jwtAssertionGenerator.getAssertionString(this.hostUser, this.authorizationServerUrl);
        HttpHeaders contentTypeHeader = new HttpHeaders();
        contentTypeHeader.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity accessTokenRequestEntity = new HttpEntity(JwtBearerAccessTokenProvider.accessTokenRequestParameters(assertionString, oAuth2ProtectedResourceDetails.getGrantType()), (MultiValueMap)contentTypeHeader);
        ResponseEntity accessTokenResponse = this.restTemplate.exchange(oAuth2ProtectedResourceDetails.getAccessTokenUri(), HttpMethod.POST, accessTokenRequestEntity, ACCESS_TOKEN_RESPONSE_TYPE, new Object[0]);
        OAuth2AccessToken accessToken = DefaultOAuth2AccessToken.valueOf((Map)((Map)accessTokenResponse.getBody()));
        if (accessToken instanceof DefaultOAuth2AccessToken) {
            this.reduceExpirationTime((DefaultOAuth2AccessToken)accessToken, 60);
        }
        return accessToken;
    }

    public boolean supportsResource(OAuth2ProtectedResourceDetails oAuth2ProtectedResourceDetails) {
        return oAuth2ProtectedResourceDetails instanceof JwtBearerResourceDetails;
    }

    public OAuth2AccessToken refreshAccessToken(OAuth2ProtectedResourceDetails oAuth2ProtectedResourceDetails, OAuth2RefreshToken oAuth2RefreshToken, AccessTokenRequest accessTokenRequest) throws UserRedirectRequiredException {
        return this.obtainAccessToken(oAuth2ProtectedResourceDetails, accessTokenRequest);
    }

    public boolean supportsRefresh(OAuth2ProtectedResourceDetails oAuth2ProtectedResourceDetails) {
        return false;
    }

    private static LinkedMultiValueMap<String, String> accessTokenRequestParameters(String assertion, String grantType) {
        LinkedMultiValueMap parameters = new LinkedMultiValueMap();
        parameters.add((Object)"grant_type", (Object)grantType);
        parameters.add((Object)"assertion", (Object)assertion);
        return parameters;
    }

    private void reduceExpirationTime(DefaultOAuth2AccessToken accessToken, int seconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(accessToken.getExpiration());
        calendar.add(13, -seconds);
        accessToken.setExpiration(calendar.getTime());
    }
}

