/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.internal.auth.AtlassianConnectSecurityContextHelper;
import com.atlassian.connect.spring.internal.request.AtlassianHostUriResolver;
import com.atlassian.connect.spring.internal.request.jwt.JwtGenerator;
import com.atlassian.connect.spring.internal.request.jwt.JwtSigningClientHttpRequestInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class JwtSigningRestTemplateFactory {
    private RestTemplateBuilder restTemplateBuilder;
    private final JwtGenerator jwtGenerator;
    private final String atlassianConnectClientVersion;
    private RestTemplate restTemplate;

    @Autowired
    public JwtSigningRestTemplateFactory(RestTemplateBuilder restTemplateBuilder, JwtGenerator jwtGenerator, @Value(value="${atlassian.connect.client-version}") String atlassianConnectClientVersion, AtlassianHostUriResolver hostUriResolver, AtlassianConnectSecurityContextHelper securityContextHelper) {
        this.restTemplateBuilder = restTemplateBuilder;
        this.jwtGenerator = jwtGenerator;
        this.atlassianConnectClientVersion = atlassianConnectClientVersion;
        JwtSigningClientHttpRequestInterceptor requestInterceptor = new JwtSigningClientHttpRequestInterceptor(jwtGenerator, atlassianConnectClientVersion, hostUriResolver, securityContextHelper);
        this.restTemplate = restTemplateBuilder.additionalInterceptors(new ClientHttpRequestInterceptor[]{requestInterceptor}).build();
    }

    public RestTemplate getJwtRestTemplate() {
        return this.restTemplate;
    }

    @Cacheable(value={"jwt-clients"})
    public RestTemplate getJwtRestTemplate(AtlassianHost host) {
        JwtSigningClientHttpRequestInterceptor requestInterceptor = new JwtSigningClientHttpRequestInterceptor(this.jwtGenerator, this.atlassianConnectClientVersion, host);
        return this.restTemplateBuilder.additionalInterceptors(new ClientHttpRequestInterceptor[]{requestInterceptor}).build();
    }
}

