/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.HttpRequestCanonicalizer;
import com.atlassian.connect.spring.internal.request.jwt.CanonicalHttpUriComponentsRequest;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@Component
public class JwtQueryHashGenerator {
    public CanonicalHttpRequest createCanonicalHttpRequest(HttpMethod httpMethod, URI uri, String baseUrl) {
        String hostContextPath = URI.create(baseUrl).getPath();
        UriComponents uriComponents = UriComponentsBuilder.fromUri((URI)uri).build();
        return new CanonicalHttpUriComponentsRequest(httpMethod, uriComponents, hostContextPath);
    }

    public String computeCanonicalRequestHash(CanonicalHttpRequest canonicalHttpRequest) {
        try {
            return HttpRequestCanonicalizer.computeCanonicalRequestHash((CanonicalHttpRequest)canonicalHttpRequest);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

