/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.CanonicalRequestUtil;
import com.atlassian.connect.spring.internal.request.AtlassianHostUriResolver;
import com.atlassian.connect.spring.internal.request.jwt.JwtBuilder;
import com.atlassian.connect.spring.internal.request.jwt.JwtQueryHashGenerator;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class JwtGenerator {
    private static final Logger log = LoggerFactory.getLogger(JwtGenerator.class);
    private AtlassianHostUriResolver hostUriResolver;
    private AddonDescriptorLoader addonDescriptorLoader;
    private AtlassianConnectProperties atlassianConnectProperties;
    private JwtQueryHashGenerator queryHashGenerator;

    @Autowired
    public JwtGenerator(AtlassianHostUriResolver hostUriResolver, AddonDescriptorLoader addonDescriptorLoader, AtlassianConnectProperties atlassianConnectProperties, JwtQueryHashGenerator queryHashGenerator) {
        this.hostUriResolver = hostUriResolver;
        this.addonDescriptorLoader = addonDescriptorLoader;
        this.atlassianConnectProperties = atlassianConnectProperties;
        this.queryHashGenerator = queryHashGenerator;
    }

    public String createJwtToken(HttpMethod httpMethod, URI uri) {
        this.assertUriAbsolute(uri);
        return this.internalCreateJwtToken(httpMethod, uri, this.getHostFromRequestUri(uri));
    }

    public String createJwtToken(HttpMethod httpMethod, URI uri, AtlassianHost host) {
        this.assertUriAbsolute(uri);
        this.assertRequestToHost(uri, host);
        return this.internalCreateJwtToken(httpMethod, uri, host);
    }

    private String internalCreateJwtToken(HttpMethod httpMethod, URI uri, AtlassianHost host) {
        CanonicalHttpRequest canonicalHttpRequest = this.queryHashGenerator.createCanonicalHttpRequest(httpMethod, uri, host.getBaseUrl());
        log.debug("Generating JWT with canonical request: {}", (Object)CanonicalRequestUtil.toVerboseString((CanonicalHttpRequest)canonicalHttpRequest));
        String queryHash = this.queryHashGenerator.computeCanonicalRequestHash(canonicalHttpRequest);
        Duration expirationTime = Duration.of(this.atlassianConnectProperties.getJwtExpirationTime().intValue(), ChronoUnit.SECONDS);
        JwtBuilder jwtBuilder = new JwtBuilder(expirationTime).issuer(this.addonDescriptorLoader.getDescriptor().getKey()).queryHash(queryHash).signature(host.getSharedSecret());
        return jwtBuilder.build();
    }

    private void assertUriAbsolute(URI uri) {
        if (!uri.isAbsolute()) {
            throw new IllegalArgumentException("The given URI is not absolute");
        }
    }

    private void assertRequestToHost(URI uri, AtlassianHost host) {
        if (!AtlassianHostUriResolver.isRequestToHost(uri, host)) {
            throw new IllegalArgumentException("The given URI is not under the base URL of the given host");
        }
    }

    private AtlassianHost getHostFromRequestUri(URI uri) {
        return this.hostUriResolver.getHostFromRequestUrl(uri).orElseThrow(() -> new IllegalArgumentException("The given URI is not under the base URL of any installed host"));
    }
}

