/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.lifecycle;

import com.atlassian.connect.spring.AddonInstalledEvent;
import com.atlassian.connect.spring.AddonUninstalledEvent;
import com.atlassian.connect.spring.AtlassianHost;
import com.atlassian.connect.spring.AtlassianHostRepository;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.AsynchronousApplicationEventPublisher;
import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.auth.jwt.JwtAuthentication;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.lifecycle.LifecycleEvent;
import com.atlassian.connect.spring.internal.lifecycle.TransactionExecutor;
import com.nimbusds.jwt.JWTClaimsSet;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.AuthenticationPrincipal;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.AsyncRequestTimeoutException;

@RestController
public class LifecycleController {
    private static final Logger log = LoggerFactory.getLogger(LifecycleController.class);
    @Autowired
    private AtlassianHostRepository hostRepository;
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    @Autowired
    private AsynchronousApplicationEventPublisher eventPublisher;
    @Autowired
    private TransactionExecutor transactionExecutor;
    @Autowired
    private AtlassianConnectProperties atlassianConnectProperties;

    public static Method getInstalledMethod() {
        return LifecycleController.getSafeMethod("installed");
    }

    public static Method getUninstalledMethod() {
        return LifecycleController.getSafeMethod("uninstalled");
    }

    private static Method getSafeMethod(String name) {
        try {
            return LifecycleController.class.getMethod(name, LifecycleEvent.class, AtlassianHostUser.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    public ResponseEntity<Void> installed(@Valid @RequestBody LifecycleEvent lifecycleEvent, @AuthenticationPrincipal AtlassianHostUser hostUser) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Supplier<ResponseEntity> installer = () -> this.installedImpl(lifecycleEvent, hostUser, authentication);
        AtomicBoolean requestTimeoutReached = new AtomicBoolean(false);
        ListenableFuture<ResponseEntity> installFuture = this.transactionExecutor.executeWithRollbackOption(installer, requestTimeoutReached);
        Integer installTimeout = this.atlassianConnectProperties.getInstallTimeout();
        try {
            return (ResponseEntity)installFuture.get((long)installTimeout.intValue(), TimeUnit.SECONDS);
        }
        catch (InterruptedException | TimeoutException e) {
            log.warn("Installation request timed out. Attempting to roll back transaction. (Timeout is {} seconds per property {}.)", (Object)installTimeout, (Object)"atlassian.connect.install-timeout");
            requestTimeoutReached.set(true);
            AsyncRequestTimeoutException asyncRequestTimeout = new AsyncRequestTimeoutException();
            asyncRequestTimeout.initCause(e);
            throw asyncRequestTimeout;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private ResponseEntity<Void> installedImpl(LifecycleEvent lifecycleEvent, AtlassianHostUser hostUser, Authentication authentication) {
        this.assertExpectedEventType(lifecycleEvent, "installed");
        if (hostUser == null) {
            Optional maybeExistingHost = this.getHostFromLifecycleEvent(lifecycleEvent);
            if (maybeExistingHost.isPresent()) {
                log.error("Installation request was not properly authenticated, but we have already installed the add-on for host [clientKey: {}, baseUrl: {}]. Subsequent installation requests must include valid JWT. Returning 401.", (Object)lifecycleEvent.clientKey, (Object)lifecycleEvent.baseUrl);
                return this.responseForMissingJwt();
            }
            maybeExistingHost = this.hostRepository.findFirstByBaseUrlOrderByLastModifiedDateDesc(lifecycleEvent.baseUrl);
            if (maybeExistingHost.isPresent()) {
                log.error("Installation request was not properly authenticated, but we have already installed the add-on for host [clientKey: {}, baseUrl: {}]. Subsequent installation requests must include valid JWT. Returning 401.", (Object)lifecycleEvent.clientKey, (Object)lifecycleEvent.baseUrl);
                return this.responseForMissingJwt();
            }
        } else {
            this.assertJwtQshClaimPresent(authentication);
            this.assertHostAuthorized(lifecycleEvent, hostUser);
        }
        AtlassianHost host = new AtlassianHost();
        host.setClientKey(lifecycleEvent.clientKey);
        host.setPublicKey(lifecycleEvent.publicKey);
        host.setOauthClientId(lifecycleEvent.oauthClientId);
        host.setSharedSecret(lifecycleEvent.sharedSecret);
        host.setBaseUrl(lifecycleEvent.baseUrl);
        host.setProductType(lifecycleEvent.productType);
        host.setDescription(lifecycleEvent.description);
        host.setServiceEntitlementNumber(lifecycleEvent.serviceEntitlementNumber);
        host.setAddonInstalled(true);
        AtlassianHost savedHost = (AtlassianHost)this.hostRepository.save((Object)host);
        log.info("Saved installation for host {} ({})", (Object)savedHost.getBaseUrl(), (Object)savedHost.getClientKey());
        this.eventPublisher.publishEventAsynchronously((ApplicationEvent)new AddonInstalledEvent((Object)this, savedHost));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    public ResponseEntity<Void> uninstalled(@Valid @RequestBody LifecycleEvent lifecycleEvent, @AuthenticationPrincipal AtlassianHostUser hostUser) {
        this.assertExpectedEventType(lifecycleEvent, "uninstalled");
        this.assertJwtQshClaimPresent(SecurityContextHolder.getContext().getAuthentication());
        Optional<AtlassianHost> maybeExistingHost = this.getHostFromLifecycleEvent(lifecycleEvent);
        if (hostUser == null) {
            if (maybeExistingHost.isPresent()) {
                log.error("Uninstallation request was not properly authenticated, but we have already installed the add-on for host [clientKey: {}, baseUrl: {}]. Uninstallation requests must include valid JWT. Returning 401.", (Object)lifecycleEvent.clientKey, (Object)lifecycleEvent.baseUrl);
                return this.responseForMissingJwt();
            }
        } else {
            this.assertHostAuthorized(lifecycleEvent, hostUser);
        }
        if (maybeExistingHost.isPresent()) {
            AtlassianHost host = maybeExistingHost.get();
            host.setAddonInstalled(false);
            this.hostRepository.save((Object)host);
            log.info("Saved uninstallation for host {} ({})", (Object)host.getBaseUrl(), (Object)host.getClientKey());
            this.eventPublisher.publishEventAsynchronously((ApplicationEvent)new AddonUninstalledEvent((Object)this, host));
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    private Optional<AtlassianHost> getHostFromLifecycleEvent(LifecycleEvent lifecycleEvent) {
        return this.hostRepository.findById((Object)lifecycleEvent.clientKey);
    }

    private void assertExpectedEventType(LifecycleEvent lifecycleEvent, String expectedEventType) {
        String eventType = lifecycleEvent.eventType;
        if (!expectedEventType.equals(eventType)) {
            log.error(String.format("Received lifecycle callback with unexpected event type %s, expected %s", eventType, expectedEventType));
            throw new InvalidLifecycleEventTypeException();
        }
    }

    private void assertHostAuthorized(LifecycleEvent lifecycleEvent, AtlassianHostUser hostUser) {
        if (!hostUser.getHost().getClientKey().equals(lifecycleEvent.clientKey)) {
            log.error("Installation request was authenticated for host " + hostUser.getHost().getClientKey() + ", but the host in the body of the request is " + lifecycleEvent.clientKey + ". Returning 403.");
            throw new HostForbiddenException();
        }
    }

    private void assertJwtQshClaimPresent(Authentication authentication) {
        Optional<JWTClaimsSet> optionalClaimsSet = Optional.ofNullable(authentication).filter(JwtAuthentication.class::isInstance).map(JwtAuthentication.class::cast).map(JwtAuthentication::getCredentials).filter(JWTClaimsSet.class::isInstance).map(JWTClaimsSet.class::cast);
        if (optionalClaimsSet.isPresent() && !optionalClaimsSet.get().getClaims().containsKey("qsh")) {
            throw new InvalidJwtTokenTypeException();
        }
    }

    private ResponseEntity<Void> responseForMissingJwt() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("WWW-Authenticate", String.format("JWT realm=\"%s\"", this.addonDescriptorLoader.getDescriptor().getKey()));
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)HttpStatus.UNAUTHORIZED).headers(headers)).build();
    }

    @ResponseStatus(code=HttpStatus.FORBIDDEN)
    private static class HostForbiddenException
    extends RuntimeException {
        private HostForbiddenException() {
        }
    }

    @ResponseStatus(code=HttpStatus.UNAUTHORIZED, reason="Invalid JWT token type")
    private static class InvalidJwtTokenTypeException
    extends RuntimeException {
        private InvalidJwtTokenTypeException() {
        }
    }

    @ResponseStatus(code=HttpStatus.BAD_REQUEST, reason="Invalid lifecycle event type")
    private static class InvalidLifecycleEventTypeException
    extends RuntimeException {
        private InvalidLifecycleEventTypeException() {
        }
    }
}

