/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal;

import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.auth.AtlassianConnectSecurityContextHelper;
import com.atlassian.connect.spring.internal.request.jwt.SelfAuthenticationTokenGenerator;
import javax.servlet.http.HttpServletRequest;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ModelAttribute;

@ControllerAdvice
public class AtlassianConnectContextModelAttributeProvider {
    private static final String ALL_JS_URL = "https://connect-cdn.atl-paas.net/all.js";
    private static final String ALL_DEBUG_JS_URL = "https://connect-cdn.atl-paas.net/all-debug.js";
    private HttpServletRequest request;
    private AtlassianConnectProperties atlassianConnectProperties;
    private AtlassianConnectSecurityContextHelper securityContextHelper;
    private SelfAuthenticationTokenGenerator selfAuthenticationTokenGenerator;

    public AtlassianConnectContextModelAttributeProvider(HttpServletRequest request, AtlassianConnectProperties atlassianConnectProperties, AtlassianConnectSecurityContextHelper securityContextHelper, SelfAuthenticationTokenGenerator selfAuthenticationTokenGenerator) {
        this.request = request;
        this.atlassianConnectProperties = atlassianConnectProperties;
        this.securityContextHelper = securityContextHelper;
        this.selfAuthenticationTokenGenerator = selfAuthenticationTokenGenerator;
    }

    @ModelAttribute
    public void addAttributes(Model model) {
        this.addModelAttribute(model, "atlassianConnectLicense", this.getLicense());
        this.addModelAttribute(model, "atlassianConnectAllJsUrl", this.getAllJsUrl());
        this.addModelAttribute(model, "atlassianConnectToken", this.getSelfAuthenticationToken());
    }

    public String getLicense() {
        return this.request.getParameter("lic");
    }

    public String getAllJsUrl() {
        return this.atlassianConnectProperties.isDebugAllJs() ? ALL_DEBUG_JS_URL : ALL_JS_URL;
    }

    public String getSelfAuthenticationToken() {
        return this.securityContextHelper.getHostUserFromSecurityContext().map(this.selfAuthenticationTokenGenerator::createSelfAuthenticationToken).orElse(null);
    }

    private void addModelAttribute(Model model, String attributeName, String value) {
        String dashedAttributeName = String.join((CharSequence)"-", attributeName.split("(?=\\p{Upper})")).toLowerCase();
        model.addAttribute(attributeName, (Object)value);
        model.addAttribute(dashedAttributeName, (Object)value);
    }
}

