/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import java.util.Collections;
import java.util.List;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.common.AuthenticationScheme;

public class JwtBearerResourceDetails
implements OAuth2ProtectedResourceDetails {
    private static String JWT_BEARER_URN = "urn:ietf:params:oauth:grant-type:jwt-bearer";
    private final String clientKey;
    private final String secret;
    private final String authServerBaseUrl;

    public JwtBearerResourceDetails(String clientKey, String secret, String authServerBaseUrl) {
        this.clientKey = clientKey;
        this.secret = secret;
        this.authServerBaseUrl = authServerBaseUrl;
    }

    public String getId() {
        return this.getClientId() + ":rest-apis";
    }

    public String getClientId() {
        return this.clientKey;
    }

    public String getAccessTokenUri() {
        return this.authServerBaseUrl + "/oauth2/token";
    }

    public boolean isScoped() {
        return false;
    }

    public List<String> getScope() {
        return Collections.emptyList();
    }

    public boolean isAuthenticationRequired() {
        return true;
    }

    public String getClientSecret() {
        return this.secret;
    }

    public AuthenticationScheme getClientAuthenticationScheme() {
        return AuthenticationScheme.header;
    }

    public String getGrantType() {
        return JWT_BEARER_URN;
    }

    public AuthenticationScheme getAuthenticationScheme() {
        return AuthenticationScheme.header;
    }

    public String getTokenName() {
        return "access_token";
    }

    public boolean isClientOnly() {
        return true;
    }
}

