/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.request.jwt.JwtBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SelfAuthenticationTokenGenerator {
    public static final String HOST_CLIENT_KEY_CLAIM = "clientKey";
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    @Autowired
    private AtlassianConnectProperties atlassianConnectProperties;

    public String createSelfAuthenticationToken(AtlassianHostUser hostUser) {
        Duration expirationTime = Duration.of(this.atlassianConnectProperties.getSelfAuthenticationExpirationTime().intValue(), ChronoUnit.SECONDS);
        JwtBuilder jwtBuilder = new JwtBuilder(expirationTime).issuer(this.addonDescriptorLoader.getDescriptor().getKey()).audience(this.addonDescriptorLoader.getDescriptor().getKey()).claim(HOST_CLIENT_KEY_CLAIM, hostUser.getHost().getClientKey()).signature(hostUser.getHost().getSharedSecret());
        hostUser.getUserKey().ifPresent(jwtBuilder::subject);
        return jwtBuilder.build();
    }
}

