/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.AtlassianHostRepository;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.request.HostUriWrapper;
import com.atlassian.connect.spring.internal.request.jwt.JwtGenerator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.support.HttpRequestWrapper;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class JwtSigningClientHttpRequestInterceptor
implements ClientHttpRequestInterceptor {
    private static final String USER_AGENT_PRODUCT = "atlassian-connect-spring-boot";
    @Autowired
    private JwtGenerator jwtGenerator;
    @Autowired
    private AtlassianHostRepository hostRepository;
    @Value(value="${atlassian.connect.client-version}")
    private String atlassianConnectClientVersion;

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpRequest interceptedRequest = this.getHostUserForRequest(request).map(hostUser -> this.wrapRequest(request, (AtlassianHostUser)hostUser)).orElse(request);
        return execution.execute(interceptedRequest, body);
    }

    protected Optional<AtlassianHostUser> getHostUserForRequest(HttpRequest request) {
        Optional<AtlassianHostUser> optionalHostUser = this.getHostUserFromSecurityContext().filter(hostUser -> HostUriWrapper.isRequestToAuthenticatedHost(request, hostUser));
        if (!optionalHostUser.isPresent()) {
            optionalHostUser = this.getHostUserFromRequestUrl(request.getURI());
        }
        return optionalHostUser;
    }

    private Optional<AtlassianHostUser> getHostUserFromSecurityContext() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Authentication::getPrincipal).filter(AtlassianHostUser.class::isInstance).map(AtlassianHostUser.class::cast);
    }

    private Optional<AtlassianHostUser> getHostUserFromRequestUrl(URI uri) {
        Optional<AtlassianHostUser> optionalHostUser = Optional.empty();
        if (uri.isAbsolute() && !(optionalHostUser = this.getHostUserFromBaseUrl(this.getBaseUrl(uri))).isPresent()) {
            optionalHostUser = this.getHostUserFromBaseUrl(this.getBaseUrlWithFirstPathElement(uri));
        }
        return optionalHostUser;
    }

    private Optional<AtlassianHostUser> getHostUserFromBaseUrl(String baseUrl) {
        Optional optionalHost = this.hostRepository.findFirstByBaseUrl(baseUrl);
        return optionalHost.map(host -> new AtlassianHostUser(host, Optional.empty()));
    }

    protected String getBaseUrl(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), null, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getBaseUrlWithFirstPathElement(URI uri) {
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), this.getFirstPathElement(uri), null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private String getFirstPathElement(URI uri) {
        int secondSlashIndex;
        String path = uri.getPath();
        if (path != null && (secondSlashIndex = path.indexOf(47, 1)) != -1) {
            path = path.substring(0, secondSlashIndex);
        }
        return path;
    }

    private HttpRequest wrapRequest(HttpRequest request, AtlassianHostUser hostUser) {
        String jwt = this.createJwt(request.getMethod(), request.getURI(), hostUser);
        URI uri = HostUriWrapper.wrapUri(request, hostUser);
        return new JwtSignedHttpRequestWrapper(request, jwt, uri);
    }

    protected String createJwt(HttpMethod method, URI uri, AtlassianHostUser hostUser) {
        return this.jwtGenerator.createJwtToken(uri, method, hostUser);
    }

    private class JwtSignedHttpRequestWrapper
    extends HttpRequestWrapper {
        private final String jwt;
        private final URI uri;

        public JwtSignedHttpRequestWrapper(HttpRequest request, String jwt, URI uri) {
            super(request);
            this.jwt = jwt;
            this.uri = uri;
            this.setJwtHeaders();
        }

        public URI getURI() {
            return this.uri;
        }

        private void setJwtHeaders() {
            HttpHeaders headers = super.getHeaders();
            headers.add("Authorization", String.format("JWT %s", this.jwt));
            headers.add("User-Agent", String.format("%s/%s", JwtSigningClientHttpRequestInterceptor.USER_AGENT_PRODUCT, JwtSigningClientHttpRequestInterceptor.this.atlassianConnectClientVersion));
        }
    }
}

