/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.AtlassianConnectProperties;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.jwt.CanonicalHttpRequest;
import com.atlassian.connect.spring.internal.jwt.CanonicalRequestUtil;
import com.atlassian.connect.spring.internal.request.jwt.JwtBuilder;
import com.atlassian.connect.spring.internal.request.jwt.JwtQueryHashGenerator;
import java.net.URI;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class JwtGenerator {
    private static final Logger log = LoggerFactory.getLogger(JwtBuilder.class);
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    @Autowired
    private AtlassianConnectProperties atlassianConnectProperties;
    @Autowired
    private JwtQueryHashGenerator queryHashGenerator;

    public String createJwtToken(URI uri, HttpMethod httpMethod, AtlassianHostUser hostUser) {
        CanonicalHttpRequest canonicalHttpRequest = this.queryHashGenerator.createCanonicalHttpRequest(httpMethod, uri, hostUser.getHost().getBaseUrl());
        log.debug("Canonical request is: " + CanonicalRequestUtil.toVerboseString((CanonicalHttpRequest)canonicalHttpRequest));
        String queryHash = this.queryHashGenerator.computeCanonicalRequestHash(canonicalHttpRequest);
        Duration expirationTime = Duration.of(this.atlassianConnectProperties.getJwtExpirationTime().intValue(), ChronoUnit.SECONDS);
        JwtBuilder jwtBuilder = new JwtBuilder(expirationTime).issuer(this.addonDescriptorLoader.getDescriptor().getKey()).queryHash(queryHash).signature(hostUser.getHost().getSharedSecret());
        hostUser.getUserKey().ifPresent(jwtBuilder::subject);
        return jwtBuilder.build();
    }
}

