/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request;

import com.atlassian.connect.spring.AtlassianHostRestClients;
import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.request.oauth2.ActorHostUrlReconcilingInterceptor;
import com.atlassian.connect.spring.internal.request.oauth2.AsUserRestTemplate;
import com.atlassian.connect.spring.internal.request.oauth2.OAuth2JwtAssertionGenerator;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AtlassianHostRestClientsImpl
implements AtlassianHostRestClients {
    private final RestTemplate jwtSigningRestTemplate;
    private AuthenticatedOAuthRestTemplateFactory authenticatedOAuthRestTemplateFactory;

    @Autowired
    public AtlassianHostRestClientsImpl(RestTemplate jwtSigningRestTemplate, AuthenticatedOAuthRestTemplateFactory authenticatedOAuthRestTemplateFactory) {
        this.jwtSigningRestTemplate = jwtSigningRestTemplate;
        this.authenticatedOAuthRestTemplateFactory = authenticatedOAuthRestTemplateFactory;
    }

    public RestTemplate authenticatedAsAddon() {
        return this.jwtSigningRestTemplate;
    }

    public RestTemplate authenticatedAsHostActor() {
        return this.authenticatedAs(this.getHostUserFromSecurityContext().orElseThrow(() -> new IllegalStateException("Was asked to authenticate the rest client as the current acting user on the host, but none could be inferred from the current request")));
    }

    public RestTemplate authenticatedAs(AtlassianHostUser hostUser) {
        return this.authenticatedOAuthRestTemplateFactory.getAuthenticatedRestTemplate(hostUser);
    }

    private Optional<AtlassianHostUser> getHostUserFromSecurityContext() {
        return Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).map(Authentication::getPrincipal).filter(AtlassianHostUser.class::isInstance).map(AtlassianHostUser.class::cast);
    }

    @Component
    public static class AuthenticatedOAuthRestTemplateFactory {
        private static final URI DEV_AUTHORIZATION_SERVER_URL = URI.create("https://auth.dev.atlassian.io");
        private static final URI PRODUCTION_AUTHORIZATION_SERVER_URL = URI.create("https://auth.atlassian.io");
        private final RestTemplate accessTokenRequestRestTemplate;
        private final OAuth2JwtAssertionGenerator jwtAssertionGenerator;

        @Autowired
        public AuthenticatedOAuthRestTemplateFactory(RestTemplate restTemplate, OAuth2JwtAssertionGenerator jwtAssertionGenerator) {
            this.accessTokenRequestRestTemplate = restTemplate;
            this.jwtAssertionGenerator = jwtAssertionGenerator;
        }

        @Cacheable(value={"oauth-2-clients"})
        public AsUserRestTemplate getAuthenticatedRestTemplate(AtlassianHostUser hostUser) {
            if (StringUtils.isBlank((CharSequence)hostUser.getHost().getOauthClientId())) {
                throw new UnsupportedOperationException("Can not act as a user for a host with no OAuthClientId");
            }
            if (!hostUser.getUserKey().isPresent()) {
                throw new IllegalArgumentException("The provided AtlassianHostUser did not specify a user to act as.");
            }
            boolean isDevHost = URI.create(hostUser.getHost().getBaseUrl()).getHost().endsWith(".jira-dev.com");
            return new AsUserRestTemplate(hostUser, isDevHost ? DEV_AUTHORIZATION_SERVER_URL : PRODUCTION_AUTHORIZATION_SERVER_URL, this.accessTokenRequestRestTemplate, new ActorHostUrlReconcilingInterceptor(hostUser), this.jwtAssertionGenerator);
        }
    }
}

