/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.lifecycle;

import com.atlassian.connect.spring.internal.descriptor.AddonDescriptor;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.lifecycle.LifecycleController;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class LifecycleControllerHandlerMapping
extends RequestMappingHandlerMapping {
    private static final int ORDER = -100;
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    private Map<Method, Function<AddonDescriptor, String>> methodUrlResolvers = new HashMap<Method, Function<AddonDescriptor, String>>();

    public LifecycleControllerHandlerMapping() {
        this.setOrder(-100);
        this.methodUrlResolvers.put(LifecycleController.getInstalledMethod(), AddonDescriptor::getInstalledLifecycleUrl);
        this.methodUrlResolvers.put(LifecycleController.getUninstalledMethod(), AddonDescriptor::getUninstalledLifecycleUrl);
    }

    protected boolean isHandler(Class<?> beanType) {
        return super.isHandler(beanType) && LifecycleController.class.equals(beanType);
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return Optional.ofNullable(this.methodUrlResolvers.get(method)).map(this::getRequestMappingInfo).orElse(null);
    }

    private RequestMappingInfo getRequestMappingInfo(Function<AddonDescriptor, String> methodUrlResolver) {
        String url = methodUrlResolver.apply(this.addonDescriptorLoader.getDescriptor());
        return RequestMappingInfo.paths((String[])new String[]{url}).methods(new RequestMethod[]{RequestMethod.POST}).build();
    }
}

