/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.descriptor;

import java.util.Optional;
import java.util.function.Function;

public class AddonDescriptor {
    private String key;
    private String baseUrl;
    private Authentication authentication;
    private Lifecycle lifecycle;

    public String getKey() {
        return this.key;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getAuthenticationType() {
        return Optional.ofNullable(this.authentication).map(Authentication::getType).orElse(null);
    }

    public String getInstalledLifecycleUrl() {
        return this.getLifecycleUrl(Lifecycle::getInstalled);
    }

    public String getUninstalledLifecycleUrl() {
        return this.getLifecycleUrl(Lifecycle::getUninstalled);
    }

    public String getEnabledLifecycleUrl() {
        return this.getLifecycleUrl(Lifecycle::getEnabled);
    }

    public String getDisabledLifecycleUrl() {
        return this.getLifecycleUrl(Lifecycle::getDisabled);
    }

    private String getLifecycleUrl(Function<Lifecycle, String> urlRetriever) {
        return Optional.ofNullable(this.lifecycle).map(urlRetriever).orElse(null);
    }

    private static class Lifecycle {
        private String installed;
        private String uninstalled;
        private String enabled;
        private String disabled;

        private Lifecycle() {
        }

        public String getInstalled() {
            return this.installed;
        }

        public String getUninstalled() {
            return this.uninstalled;
        }

        public String getEnabled() {
            return this.enabled;
        }

        public String getDisabled() {
            return this.disabled;
        }
    }

    private static class Authentication {
        private String type;

        private Authentication() {
        }

        public String getType() {
            return this.type;
        }
    }
}

