/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.auth.jwt;

import com.atlassian.connect.spring.AtlassianHostRepository;
import com.atlassian.connect.spring.internal.auth.jwt.JwtAuthenticationProvider;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurer;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.authentication.configurers.GlobalAuthenticationConfigurerAdapter;

@Configuration
@Order(value=0x7FFFFFFF)
public class JwtGlobalAuthenticationConfigurerAdapter
extends GlobalAuthenticationConfigurerAdapter {
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;
    @Autowired
    private AtlassianHostRepository hostRepository;

    public void init(AuthenticationManagerBuilder authenticationManagerBuilder) throws Exception {
        JwtAuthenticationProvider jwtAuthenticationProvider = new JwtAuthenticationProvider(this.addonDescriptorLoader, this.hostRepository);
        authenticationManagerBuilder.apply((SecurityConfigurer)new JwtSecurityConfigurer(jwtAuthenticationProvider));
    }

    private static class JwtSecurityConfigurer
    implements SecurityConfigurer<AuthenticationManager, AuthenticationManagerBuilder> {
        private final JwtAuthenticationProvider jwtAuthenticationProvider;

        public JwtSecurityConfigurer(JwtAuthenticationProvider jwtAuthenticationProvider) {
            this.jwtAuthenticationProvider = jwtAuthenticationProvider;
        }

        public void init(AuthenticationManagerBuilder builder) throws Exception {
        }

        public void configure(AuthenticationManagerBuilder authenticationManagerBuilder) throws Exception {
            authenticationManagerBuilder.authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider);
        }
    }
}

