/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.oauth2;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.request.oauth2.ActorHostUrlReconcilingInterceptor;
import com.atlassian.connect.spring.internal.request.oauth2.JwtBearerAccessTokenProvider;
import com.atlassian.connect.spring.internal.request.oauth2.JwtBearerResourceDetails;
import com.atlassian.connect.spring.internal.request.oauth2.OAuth2JwtAssertionGenerator;
import java.net.URI;
import java.util.Collections;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.web.client.RestTemplate;

public class AsUserRestTemplate
extends OAuth2RestTemplate {
    public AsUserRestTemplate(AtlassianHostUser hostUser, URI authorizationServerBaseUrl, RestTemplate accessTokenRequestRestTemplate, ActorHostUrlReconcilingInterceptor interceptor, OAuth2JwtAssertionGenerator jwtAssertionGenerator) {
        super((OAuth2ProtectedResourceDetails)new JwtBearerResourceDetails(hostUser.getHost().getClientKey(), hostUser.getHost().getSharedSecret(), authorizationServerBaseUrl.toASCIIString()));
        JwtBearerAccessTokenProvider accessTokenProvider = new JwtBearerAccessTokenProvider(hostUser, authorizationServerBaseUrl, accessTokenRequestRestTemplate, jwtAssertionGenerator);
        this.setAccessTokenProvider(accessTokenProvider);
        this.setInterceptors(Collections.singletonList(interceptor));
    }
}

