/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.request.jwt;

import com.atlassian.connect.spring.AtlassianHostUser;
import com.atlassian.connect.spring.internal.descriptor.AddonDescriptorLoader;
import com.atlassian.connect.spring.internal.request.jwt.JwtBuilder;
import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;

@Component
public class JwtGenerator {
    @Autowired
    private AddonDescriptorLoader addonDescriptorLoader;

    public String createJwtToken(URI uri, HttpMethod httpMethod, AtlassianHostUser hostUser) {
        JwtBuilder jwtBuilder = new JwtBuilder().issuer(this.addonDescriptorLoader.getDescriptor().getKey()).queryHash(httpMethod, uri, hostUser.getHost().getBaseUrl()).signature(hostUser.getHost().getSharedSecret());
        this.maybeIncludeJwtSubjectClaim(jwtBuilder, hostUser);
        return jwtBuilder.build();
    }

    private JwtBuilder maybeIncludeJwtSubjectClaim(JwtBuilder jwtBuilder, AtlassianHostUser hostUser) {
        if (this.includeJwtSubjectClaim() && hostUser.getUserKey().isPresent()) {
            jwtBuilder.subject((String)hostUser.getUserKey().get());
        }
        return jwtBuilder;
    }

    private boolean includeJwtSubjectClaim() {
        return false;
    }
}

